package com.yeejoin.amos.boot.module.common.biz.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.common.api.dto.FeedbackSuggestionsDto;
import com.yeejoin.amos.boot.module.common.api.entity.FeedbackSuggestions;
import com.yeejoin.amos.boot.module.common.api.enums.ProblemTypeEnum;
import com.yeejoin.amos.boot.module.common.biz.service.impl.FeedbackSuggestionsServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;

/**
 * @author system_generator
 * @date 2025-05-15
 */
@RestController
@Api(tags = "反馈建议表")
@RequestMapping(value = "/feedback-suggestions")
public class FeedbackSuggestionsController extends BaseController {

    @Autowired
    FeedbackSuggestionsServiceImpl feedbackSuggestionsServiceImpl;

    /**
     * 新增
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/save")
    @ApiOperation(httpMethod = "POST", value = "新增", notes = "新增")
    public ResponseModel<FeedbackSuggestions> save(@RequestBody FeedbackSuggestionsDto dto) {
        return ResponseHelper.buildResponse(feedbackSuggestionsServiceImpl.saveFeedbackSuggestions(dto));
    }


    /**
     * 问题类型list
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/problemTyperList")
    @ApiOperation(httpMethod = "GET", value = "问题类型list", notes = "问题类型list")
    public ResponseModel<List<JSONObject>> problemTyperList() {
        List<JSONObject> result = new ArrayList<>();
        for (ProblemTypeEnum value : ProblemTypeEnum.values()) {
            result.add(new JSONObject().fluentPut("key", value.getId()).fluentPut("value", value.getId()).fluentPut("label", value.getDescription()));
        }
        return ResponseHelper.buildResponse(result);
    }

    /**
     * 列表分页查询
     *
     * @param current 当前页
     * @param size    每页大小
     * @return res
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/page")
    @ApiOperation(httpMethod = "GET", value = "分页查询", notes = "分页查询")
    public ResponseModel<IPage<FeedbackSuggestions>> queryForPage(@RequestParam(value = "current") int current,
                                                                  @RequestParam(value = "size") int size,
                                                                  @RequestParam(value = "status", required = false) String status
    ) {
        return ResponseHelper.buildResponse(feedbackSuggestionsServiceImpl.queryForFeedbackSuggestionsPage(current, size, status));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/dataExport")
    @ApiOperation(httpMethod = "GET", value = "数据导出", notes = "数据导出")
    public void dataExport(HttpServletResponse response) {
        feedbackSuggestionsServiceImpl.dataExport(response);
    }
}
