package com.yeejoin.amos.boot.module.cylinder.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.util.Date;

/**
 * 维保信息表
 *
 * @author litw
 * @date 2021-09-22
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="MaintainInfoDto", description="维保信息表")
public class MaintainInfoDto  extends BaseDto {

   private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "电梯id")
    private String enevatorId;


    @ApiModelProperty(value = "最新维保时间")
    private Date maintainTime;

    @ApiModelProperty(value = "下次维保时间")
    private Date nextMaintainTime;

    @ApiModelProperty(value = "维保单位id")
    private String maintainUnitId;

    @ApiModelProperty(value = "维保单位")
    private String maintainUnit;

    @ApiModelProperty(value = "维保人员id")
    private String maintainPersonId;

    @ApiModelProperty(value = "维保人员")
    private String maintainPerson;

    @ApiModelProperty(value = "更新时间")
    private Date updateTime;

}
