package com.yeejoin.amos.boot.module.cylinder.api.dto;

import java.util.Date;
import java.util.List;

import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import com.yeejoin.amos.boot.module.cylinder.api.entity.TzsJgFile;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 特种设备检验信息Dto
 *
 * @author duanwei
 * @date 2022-07-26
 */
@Data
public class TzsJgInspectionInfoDto extends BaseDto {

	private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "id")
	/**
	 * id
	 */
	private Long sequenceNbr;
	@ApiModelProperty(value = "设备唯一标识码")
	/**
	 * 设备唯一标识码
	 */
	private String sequenceCode;
	@ApiModelProperty(value = "监管系统唯一编码")
	/**
	 * 监管系统唯一编码
	 */
	private String superviseCode;
	@ApiModelProperty(value = "设备代码")
	/**
	 * 设备代码
	 */
	private String equCode;
	@ApiModelProperty(value = "检验类型(1法定类监督检验2法定类定期检验3非法定类检验4委托类检验)")
    /**
    * 检验类型(1法定类监督检验
2法定类定期检验
3非法定类检验
4委托类检验)
    */
    private String inspectType;
	@ApiModelProperty(value = "检验机构名称")
	/**
	 * 检验机构名称
	 */
	private String inspectOrgName;
	@ApiModelProperty(value = "检验报告ID")
	/**
	 * 检验报告ID
	 */
	private String inspectReportNum;
	@ApiModelProperty(value = "检验人员")
	/**
	 * 检验人员
	 */
	private String inspectStaff;
	@ApiModelProperty(value = "检验日期")
	/**
	 * 检验日期
	 */
	private Date inspectDate;
    private String inspectDateStr;
	@ApiModelProperty(value = "检验结论(合格，复检合格等)")
	/**
	 * 检验结论(合格，复检合格等)
	 */
	private String inspectConclusion;
	@ApiModelProperty(value = "安全状况等级")
	/**
	 * 安全状况等级
	 */
	private String safetyLevel;
	@ApiModelProperty(value = "检验问题备注")
	/**
	 * 检验问题备注
	 */
	private String problemRemark;
	@ApiModelProperty(value = "下次检验日期")
	/**
	 * 下次检验日期
	 */
	private Date nextInspectDate;
	private String nextInspectDateStr;
	@ApiModelProperty(value = "同步时间")
	/**
	 * 同步时间
	 */
	private Date syncDate;
	@ApiModelProperty(value = "同步状态（0-新增   1-更新   2-删除）")
	/**
	 * 同步状态（0-新增 1-更新 2-删除）
	 */
	private Integer syncState;
	@ApiModelProperty(value = "对接公司编码")
	/**
	 * 对接公司编码
	 */
	private String appId;
	@ApiModelProperty(value = "创建时间")
	/**
	 * 创建时间
	 */
	private Date recDate;
	@ApiModelProperty(value = "操作人员")
	/**
	 * 操作人员
	 */
	private String recUserId;
	
	private List<TzsJgFile> inspectionReport;

}
