package com.yeejoin.amos.boot.module.cylinder.biz.job;

import com.yeejoin.amos.boot.module.cylinder.api.entity.CylinderQuestionInfo;
import com.yeejoin.amos.boot.module.cylinder.api.enums.QuestionTypeEnum;
import com.yeejoin.amos.boot.module.cylinder.biz.service.impl.CylinderQuestionInfoServiceImpl;
import com.yeejoin.amos.boot.module.cylinder.flc.api.dto.CylinderInfoDto;
import com.yeejoin.amos.boot.module.cylinder.flc.api.mapper.CylinderInfoMapper;
import net.javacrumbs.shedlock.spring.annotation.SchedulerLock;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import javax.validation.constraints.NotNull;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author Administrator
 */
@Component
@EnableScheduling
public class InspectionQuestionJob {


    private CylinderInfoMapper cylinderInfoMapper;

    private CylinderQuestionInfoServiceImpl questionInfoService;

    public InspectionQuestionJob(CylinderInfoMapper cylinderInfoMapper,
                                 CylinderQuestionInfoServiceImpl questionInfoService) {
        this.cylinderInfoMapper = cylinderInfoMapper;
        this.questionInfoService = questionInfoService;
    }


    /**
     * 检验超期
     */
    @SchedulerLock(name = "genOverdueQuestionJobCylinder", lockAtMostFor = "PT20M")
    @Scheduled(cron = "${inspection.overdue.job.cron:0 0/30 * * * ?}")
    @Transactional(rollbackFor = Exception.class)
    public void genOverdueQuestion() {
        genOverdueQuestionImpl();
    }

    public void genOverdueQuestionImpl() {
        List<CylinderInfoDto> cylinderList = cylinderInfoMapper.queryCylinderOfInspectionOverdue(QuestionTypeEnum.JYCQ.getCode());
        List<CylinderQuestionInfo> cylinderQuestionInfos = cylinderList.stream().map(cylinderInfoDto -> {
            CylinderQuestionInfo cylinderQuestionInfo = new CylinderQuestionInfo();
            cylinderQuestionInfo.setQuestionType(QuestionTypeEnum.JYCQ.getCode());
            cylinderQuestionInfo.setQuestionTypeName(QuestionTypeEnum.JYCQ.getName());
            return fillCommonField(cylinderInfoDto, cylinderQuestionInfo);
        }).collect(Collectors.toList());
        // 已经生成的数据不再重复生成
        if (cylinderQuestionInfos.size() > 0) {
            questionInfoService.saveBatch(cylinderQuestionInfos);
        }
    }


    /**
     * 检验不合格任务
     */
    @SchedulerLock(name = "genInspectionUnqualifiedQuestionJobCylinder", lockAtMostFor = "PT20M")
    @Scheduled(cron = "${inspection.unqualified.job.cron:0 0/30 * * * ?}")
    @Transactional(rollbackFor = Exception.class)
    public void genInspectionUnqualifiedQuestion() {
        genInspectionUnqualifiedQuestionImpl();
    }

    public void genInspectionUnqualifiedQuestionImpl() {
        List<CylinderInfoDto> cylinderList = cylinderInfoMapper.queryCylinderOfUnqualifiedQuestion(QuestionTypeEnum.JYBHG.getCode());
        List<CylinderQuestionInfo> cylinderQuestionInfos = cylinderList.stream().map(cylinderInfoDto -> {
            CylinderQuestionInfo cylinderQuestionInfo = new CylinderQuestionInfo();
            cylinderQuestionInfo.setQuestionType(QuestionTypeEnum.JYBHG.getCode());
            cylinderQuestionInfo.setQuestionTypeName(QuestionTypeEnum.JYBHG.getName());
            return fillCommonField(cylinderInfoDto, cylinderQuestionInfo);
        }).collect(Collectors.toList());
        if (cylinderQuestionInfos.size() > 0) {
            questionInfoService.saveBatch(cylinderQuestionInfos);
        }
    }


    @NotNull
    private CylinderQuestionInfo fillCommonField(CylinderInfoDto cylinderInfoDto, CylinderQuestionInfo cylinderQuestionInfo) {
        cylinderQuestionInfo.setHappenDate(new Date());
        cylinderQuestionInfo.setRecDate(new Date());
        cylinderQuestionInfo.setRegionCode(cylinderInfoDto.getRegionCode());
        cylinderQuestionInfo.setQuestionObjectId(cylinderInfoDto.getSequenceNbr() + "");
        cylinderQuestionInfo.setQuestionObjectName(cylinderInfoDto.getFactoryNum());
        cylinderQuestionInfo.setQuestionAttributionId(cylinderInfoDto.getAppId());
        cylinderQuestionInfo.setQuestionAttributionName(cylinderInfoDto.getUnitName());
        return cylinderQuestionInfo;
    }
}
