package com.yeejoin.amos.boot.module.cylinder.flc.biz.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.yeejoin.amos.boot.module.common.api.dto.AttachmentDto;
import com.yeejoin.amos.boot.module.common.biz.service.impl.OrgUsrServiceImpl;
import com.yeejoin.amos.boot.module.common.biz.service.impl.SourceFileServiceImpl;
import com.yeejoin.amos.boot.module.cylinder.flc.api.dto.EquipmentIndexDto;
import com.yeejoin.amos.boot.module.cylinder.flc.api.entity.Equipment;
import com.yeejoin.amos.boot.module.cylinder.flc.api.entity.EquipmentIndex;
import com.yeejoin.amos.boot.module.cylinder.flc.api.entity.InformEquipment;
import com.yeejoin.amos.boot.module.cylinder.flc.api.mapper.InformEquipmentMapper;
import com.yeejoin.amos.boot.module.cylinder.flc.api.service.IInformEquipmentService;
import com.yeejoin.amos.boot.module.cylinder.flc.api.dto.InformEquipmentDto;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.typroject.tyboot.core.foundation.utils.Bean;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 告知申请-设备信息表服务实现类
 *
 * @author system_generator
 * @date 2021-12-10
 */
@Service
public class InformEquipmentServiceImpl extends BaseService<InformEquipmentDto,InformEquipment,InformEquipmentMapper> implements IInformEquipmentService {

    @Autowired
    SourceFileServiceImpl sourceFileService;

    @Autowired
    EquipmentIndexServiceImpl equipmentIndexServiceImpl;

    @Autowired
    EquipmentServiceImpl equipmentServiceImpl;

    @Transactional
    @Override
    public InformEquipmentDto saveInformEquipment(InformEquipmentDto model) {
        InformEquipment tempEquipment = this.getById(model.getSourceEquipmentId());
        String address = model.getAddress();
        String latitude = model.getLatitude();
        String longitude = model.getLongitude();

        if(tempEquipment != null) { // 已经存在不必再次保存直接返回

            this.update(new LambdaUpdateWrapper<InformEquipment>().eq(InformEquipment::getSequenceNbr,tempEquipment.getSequenceNbr())
                    .set(InformEquipment::getAddress,address).set(InformEquipment::getLatitude,latitude)
            .set(InformEquipment::getLongitude,longitude));

            return model;
        }


        // 首先获取设备基本信息并复制
        Equipment sourceEquip = equipmentServiceImpl.getById(model.getSourceEquipmentId());
        BeanUtils.copyProperties(sourceEquip,model);
        model.setSequenceNbr(null);
        model.setRecDate(new Date());
        model.setRecUserId(null);
        model.setRecUserName(null);
        model.setAddress(address);
        model.setLatitude(latitude);
        model.setLongitude(longitude);
        model.setIsDelete(false);
        this.createWithModel(model);

        // 保存设备参数信息
        List<EquipmentIndex> indexList = equipmentIndexServiceImpl.list(new LambdaQueryWrapper<EquipmentIndex>().eq(EquipmentIndex::getEquipmentId,model.getSourceEquipmentId()));
        if(indexList != null && indexList.size()>0) {
            for(EquipmentIndex t : indexList) {
                EquipmentIndexDto temp = new EquipmentIndexDto();
                BeanUtils.copyProperties(t,temp);
                temp.setSequenceNbr(null);
                temp.setEquipmentId(model.getSequenceNbr());
                temp.setEquipmentName(model.getName());
                equipmentIndexServiceImpl.createWithModel(temp);
            }
        }

        // 获取设备附件信息 保存附件信息
        // 原附件信息
        Map<String, List<AttachmentDto>> sourceAttach = sourceFileService.getAttachments(sourceEquip.getSequenceNbr());
        for(  Map.Entry<String, List<AttachmentDto>> m :sourceAttach.entrySet()) {
            List<AttachmentDto> tempList = m.getValue();
            tempList.stream().forEach(l -> {
                l.setSequenceNbr(null);
            });
        }
        if(sourceAttach != null) {
            sourceFileService.saveAttachments(model.getSequenceNbr(), sourceAttach);
        }
        return model;
    }


    /**
     * 分页查询
     */
    public Page<InformEquipmentDto> queryForInformEquipmentPage(Page<InformEquipmentDto> page)   {
        return this.queryForPage(page, null, false);
    }

    /**
     * 列表查询 示例
     */
    public List<InformEquipmentDto> queryForInformEquipmentList()   {
        return this.queryForList("" , false);
    }

    @Override
    public InformEquipmentDto getEquipmentById(Long sequenceNbr) {
        // 获取基本信息
        InformEquipment equipment = this.getById(sequenceNbr);
        InformEquipmentDto result = new InformEquipmentDto();
        BeanUtils.copyProperties(equipment,result);
        // 封装附件
        result.setAttachments(sourceFileService.getAttachments(equipment.getSequenceNbr()));

        // 封装详细参数
        List<EquipmentIndex> indexList = equipmentIndexServiceImpl.list(new LambdaQueryWrapper<EquipmentIndex>().eq(EquipmentIndex::getEquipmentId,equipment.getSequenceNbr()));
        List<EquipmentIndexDto> dtoList = new ArrayList<>();
        indexList.stream().forEach(t -> {
            EquipmentIndexDto temp = new EquipmentIndexDto();
            BeanUtils.copyProperties(t,temp);
            dtoList.add(temp);
        });
        result.setEquipmentIndex(dtoList);
        return result;
    }

    @Override
    public InformEquipmentDto updateEquipment(InformEquipmentDto model) {
        this.updateWithModel(model);
        saveSourceFile(model);
        // 先删除参数信息 再添加新的参数信息
        equipmentIndexServiceImpl.remove(new LambdaQueryWrapper<EquipmentIndex>().eq(EquipmentIndex::getEquipmentId,model.getSequenceNbr()));
        // 保存设备参数信息
        List<EquipmentIndexDto> equipmentIndex = model.getEquipmentIndex();
        if(equipmentIndex != null && equipmentIndex.size()>0) {
            for(EquipmentIndexDto t : equipmentIndex) {
                t.setEquipmentId(model.getSequenceNbr());
                t.setEquipmentName(model.getName());
                equipmentIndexServiceImpl.createWithModel(t);
            }
        }
        Bean.copyExistPropertis(this.queryBySeq(model.getSequenceNbr()), model);
        return model;
    }

    @Override
    public List<InformEquipmentDto> getEquipListByInformId(Long sequenceNbr) {

        List<InformEquipment> list = this.list(new LambdaQueryWrapper<InformEquipment>().eq(InformEquipment::getIsDelete,false).eq(InformEquipment::getInformId,sequenceNbr));
        List<InformEquipmentDto> result = new ArrayList<>();
        list.stream().forEach(t -> {
            InformEquipmentDto tempDto = new InformEquipmentDto();
            BeanUtils.copyProperties(t,tempDto);
            // 封装附件
            tempDto.setAttachments(sourceFileService.getAttachments(t.getSequenceNbr()));
            // 封装详细参数
            List<EquipmentIndex> indexList = equipmentIndexServiceImpl.list(new LambdaQueryWrapper<EquipmentIndex>().eq(EquipmentIndex::getEquipmentId,t.getSequenceNbr()));
            List<EquipmentIndexDto> dtoList = new ArrayList<>();
            indexList.stream().forEach(i -> {
                EquipmentIndexDto temp = new EquipmentIndexDto();
                BeanUtils.copyProperties(i,temp);
                dtoList.add(temp);
            });
            tempDto.setEquipmentIndex(dtoList);
            result.add(tempDto);
        });
        return result;
    }


    // 保存附件信息
    public void saveSourceFile(InformEquipmentDto model) {
        if (model.getAttachments() != null) {
            sourceFileService.saveAttachments(model.getSequenceNbr(), model.getAttachments());
        }
    }
}