package com.yeejoin.amos.boot.module.jg.api.converter;

import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.CellData;
import com.alibaba.excel.metadata.GlobalConfiguration;
import com.alibaba.excel.metadata.property.ExcelContentProperty;

public class NondestructConverter implements Converter<String> {

    private static final String CI_FEN = "磁粉";
    private static final String SHE_XIAN = "射线";
    private static final String CHAO_SENG = "超声";
    private static final String SHEN_TOU = "渗透";


    @Override
    public Class<?> supportJavaTypeKey() {
        // 实体类中对象属性类型
        return String.class;
    }

    @Override
    public CellDataTypeEnum supportExcelTypeKey() {
        // Excel中对应的CellData属性类型
        return CellDataTypeEnum.STRING;
    }

    @Override
    public String convertToJavaData(CellData cellData, ExcelContentProperty excelContentProperty,
                                    GlobalConfiguration globalConfiguration) {
        // 从Cell中读取数据
        String cellValue = cellData.getStringValue();
        // 判断Excel中的值，将其转换为预期的数值
        if (CI_FEN.equals(cellValue)) {
            return "5988";
        } else if (SHE_XIAN.equals(cellValue)) {
            return "5986";
        } else if (CHAO_SENG.equals(cellValue)) {
            return "5987";
        }
        return "5989";
    }

    @Override
    public CellData convertToExcelData(String o, ExcelContentProperty excelContentProperty, GlobalConfiguration globalConfiguration) throws Exception {
        // 判断实体类中获取的值，转换为Excel预期的值，并封装为CellData对象
        if (o == null) {
            return new CellData("");
        } else if (o.equals("5988")) {
            return new CellData(CI_FEN);
        } else if (o.equals("5986")) {
            return new CellData(SHE_XIAN);
        } else if (o.equals("5987")) {
            return new CellData(CHAO_SENG);
        }
        return new CellData(SHEN_TOU);
    }
}