package com.yeejoin.amos.boot.module.jg.biz.controller;

import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import java.util.List;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.JgInstallationNoticeEqServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.jg.api.dto.JgInstallationNoticeEqDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 安装告知设备关系表
 *
 * @author system_generator
 * @date 2023-12-18
 */
@RestController
@Api(tags = "安装告知设备关系表Api")
@RequestMapping(value = "/jg-installation-notice-eq")
public class JgInstallationNoticeEqController extends BaseController {

    @Autowired
    JgInstallationNoticeEqServiceImpl jgInstallationNoticeEqServiceImpl;

    /**
     * 新增安装告知设备关系表
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增安装告知设备关系表", notes = "新增安装告知设备关系表")
	public ResponseModel<JgInstallationNoticeEqDto> save(@RequestBody JgInstallationNoticeEqDto model) {
	    model = jgInstallationNoticeEqServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新安装告知设备关系表", notes = "根据sequenceNbr更新安装告知设备关系表")
	public ResponseModel<JgInstallationNoticeEqDto> updateBySequenceNbrJgInstallationNoticeEq(@RequestBody JgInstallationNoticeEqDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(jgInstallationNoticeEqServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除安装告知设备关系表", notes = "根据sequenceNbr删除安装告知设备关系表")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(jgInstallationNoticeEqServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个安装告知设备关系表",  notes = "根据sequenceNbr查询单个安装告知设备关系表")
	public ResponseModel<JgInstallationNoticeEqDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(jgInstallationNoticeEqServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "安装告知设备关系表分页查询",  notes = "安装告知设备关系表分页查询")
	public ResponseModel<Page<JgInstallationNoticeEqDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size) {
	    Page<JgInstallationNoticeEqDto> page = new Page<JgInstallationNoticeEqDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(jgInstallationNoticeEqServiceImpl.queryForJgInstallationNoticeEqPage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "安装告知设备关系表列表全部数据查询",   notes = "安装告知设备关系表列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<JgInstallationNoticeEqDto>> selectForList() {
	    return ResponseHelper.buildResponse(jgInstallationNoticeEqServiceImpl.queryForJgInstallationNoticeEqList());
	}
}
