package com.yeejoin.amos.boot.module.jg.biz.handler.toBeSubmit;

import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.module.jg.api.enums.BusinessTypeEnum;
import com.yeejoin.amos.boot.module.jg.biz.handler.strategy.ToBeSubmitDetailStrategy;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.JgTransferNoticeServiceImpl;
import com.yeejoin.amos.boot.module.ymt.api.enums.ApplicationFormTypeEnum;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import java.util.HashMap;
import java.util.Map;

@Component
public class TransferNoticeStrategyHandler implements ToBeSubmitDetailStrategy {

    @Autowired
    private JgTransferNoticeServiceImpl jgTransferNoticeService;

    @Override
    public Map<String, Map<String, Object>> getDetails(Long sequenceNbr, ReginParams reginParams) {
        Map<String, Map<String, Object>> notice = jgTransferNoticeService.queryBySequenceNbr(sequenceNbr, reginParams.getCompany());
        Map<String, Object> transferInfo = notice.get("transferNoticeInfo");

        Map<String, Object> basic = new HashMap<>();
        basic.put("type", ApplicationFormTypeEnum.YZGZ.getBusinessCode());
        basic.put("receiveOrgCreditCode", transferInfo.get("receiveOrgCode"));
        basic.put("code", transferInfo.get("EQU_LIST_CODE"));
        basic.put("equCategory", transferInfo.get("EQU_CATEGORY_CODE"));
        basic.put("isTempEquip", true);
        Map<String, Map<String, Object>> result = new HashMap<>();
        result.put("notice", transferInfo);
        result.put("basic", basic);
        return result;
    }

    @Override
    public String supportBusinessType() {
        return BusinessTypeEnum.JG_ADVICE_REMOVAL.getName();
    }
}
