package com.yeejoin.amos.boot.module.jg.biz.service.impl;

import io.seata.spring.annotation.GlobalTransactional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Map;

@Service
public class ElevatorDataTransactionService {

    private final DataDockServiceImpl dataDockService;

    @Autowired
    public ElevatorDataTransactionService(@Lazy DataDockServiceImpl dataDockService) {
        this.dataDockService = dataDockService;
    }

    @Transactional(rollbackFor = Exception.class)
    @GlobalTransactional(rollbackFor = Exception.class)
    public Object saveSingleElevatorData(Map<String, Object> equ) {
        return dataDockService.saveElevatorDataInTransaction(equ, "jg_his_xa", null);
    }
}
