package com.yeejoin.amos.boot.module.jyjc.biz.event.rule;

import com.yeejoin.amos.boot.module.jyjc.biz.event.IRuleDataPrepare;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Component
@RequiredArgsConstructor
public class RuleDataPrepareHandlerFactory {
    private final List<IRuleDataPrepare> ruleDataPrepares;
    private final Map<Boolean, IRuleDataPrepare> ruleDataPrepareMap = new ConcurrentHashMap<>();

    public IRuleDataPrepare getRuleDataPrepare(Boolean enable) {
        return ruleDataPrepareMap.computeIfAbsent(enable, k -> {
            for (IRuleDataPrepare ruleDataPrepare : ruleDataPrepares) {
                if (ruleDataPrepare.supportType().equals(enable)) {
                    return ruleDataPrepare;
                }
            }
            throw new BadRequest("not found handler for " + enable);
        });
    }
}
