package com.yeejoin.amos.boot.module.jyjc.biz.result.factory;

import com.yeejoin.amos.boot.module.jyjc.biz.result.processor.core.ResultDataProcessor;
import com.yeejoin.amos.boot.module.jyjc.biz.result.factory.support.SupportableResultDataProcessor;
import com.yeejoin.amos.boot.module.jyjc.biz.result.wrapper.ResultDataProcessorWrapper;
import com.yeejoin.amos.component.robot.BadRequest;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Component
@RequiredArgsConstructor
public class ResultProcessorFactory {

    private final Map<String, ResultDataProcessor> processorMap = new ConcurrentHashMap<>();

    private final List<SupportableResultDataProcessor> processors;

    public ResultDataProcessor getProcessor(String equList) {
        return processorMap.computeIfAbsent(equList, k ->
                new ResultDataProcessorWrapper(
                        processors.stream()
                                .filter(p -> p.support(equList))
                                .findFirst()
                                .orElseThrow(() -> new BadRequest("No processor found for: " + equList))
                )
        );
    }
}
