package com.yeejoin.amos.boot.module.statistcs.biz.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.statistcs.biz.service.impl.EnterpriseBizByTCMServiceImpl;
import com.yeejoin.amos.boot.module.statistcs.biz.service.impl.EnterpriseBizServiceImpl;
import com.yeejoin.amos.boot.module.ymt.api.dto.TzBaseEnterpriseInfoDto;
import com.yeejoin.amos.boot.module.ymt.api.entity.PageParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;
import java.util.Map;

/**
 * @author Administrator
 */
@RestController
@RequestMapping(value = "/dp/biz-enterprise")
@Api(tags = "大屏-企业-业务API")
public class EnterpriseBizController {

    private final EnterpriseBizServiceImpl enterpriseBizService;

    private final EnterpriseBizByTCMServiceImpl enterpriseBizByTCMService;

    @Autowired
    public EnterpriseBizController(EnterpriseBizServiceImpl enterpriseBizService,
                                   EnterpriseBizByTCMServiceImpl enterpriseBizByTCMService) {
        this.enterpriseBizService = enterpriseBizService;
        this.enterpriseBizByTCMService = enterpriseBizByTCMService;
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @RequestMapping(value = "/page", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "根据id查询", notes = "根据id查询")
    public ResponseModel<IPage<TzBaseEnterpriseInfoDto>> page(PageParam pageParam,
                                                              TzBaseEnterpriseInfoDto tzBaseEnterpriseInfoDto) {
        return ResponseHelper.buildResponse(enterpriseBizService.page(pageParam, tzBaseEnterpriseInfoDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @RequestMapping(value = "/getInfoByUseCode/map", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "根据统一信用代码查询企业详情返回map", notes = "根据统一信用代码查询企业详情返回map")
    public ResponseModel<Map<String, Object>> getInfoByUseCodeMap(String useCode) {
        return ResponseHelper.buildResponse(enterpriseBizByTCMService.getInfoByUseCodeMap(useCode));
    }
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @RequestMapping(value = "/getTwoRules", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "获取规定计划信息", notes = "获取规定计划信息")
    public ResponseModel<Map<String, Object>> getTwoRules(@RequestParam Map<String, Object> map) {
        JSONObject jsonObject = new JSONObject(map);
        Page<Map<String,Object>> page = new Page<>();
        page.setCurrent(Long.valueOf(jsonObject.getString("current")));
        page.setSize(Long.valueOf(jsonObject.getString("size")));
        return ResponseHelper.buildResponse(enterpriseBizByTCMService.getTwoRules(page,jsonObject));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @RequestMapping(value = "/getPlanCheck", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "获取规定计划信息执行详情", notes = "获取规定计划信息执行详情")
    public ResponseModel<List<Map<String, Object>>> getPlanCheck(@RequestParam String planTaskDetailId) {
        return ResponseHelper.buildResponse(enterpriseBizByTCMService.getPlanCheck(planTaskDetailId));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/personPage")
    @ApiOperation(httpMethod = "GET", value = "查询人员列表", notes = "查询人员列表")
    public ResponseModel<Page<Map<String, Object>>> personPage(@RequestParam Map<String, Object> map) {
        JSONObject jsonObject = new JSONObject(map);
        Page<Map<String,Object>> page = new Page<>();
        page.setCurrent(Long.valueOf(jsonObject.getString("current")));
        page.setSize(Long.valueOf(jsonObject.getString("size")));
        return ResponseHelper.buildResponse(enterpriseBizByTCMService.getPersonPage(jsonObject, page));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/getPostList")
    @ApiOperation(httpMethod = "GET", value = "查询人员类型", notes = "查询人员类型")
    public ResponseModel<List<Map<String, Object>>> getPostList() {
        return ResponseHelper.buildResponse(enterpriseBizByTCMService.getPostList());
    }
}
