package com.yeejoin.amos.boot.module.tcm.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 平台操作接口类型枚举
 *
 ***/
@Getter
@AllArgsConstructor
public enum PlatformOpTopicEnum {


    OPERATION_LOG("/amos/operation/log", "平台操作日志主题"),
    COMPANY_ORG_CODE_UPDATE("amos/company/orgCode/update", "单位orgCode变更主题");

    private String topic;
    private String desc;

    public static PlatformOpTopicEnum getEnumByCode(String code) {
        for (PlatformOpTopicEnum status : PlatformOpTopicEnum.values()) {
            if (status.getTopic().equals(code)) {
                return status;
            }
        }
        return null;
    }
}
