package com.yeejoin.amos.patrol.business.util;


import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * <pre>
 * 返回封装对象
 * </pre>
 *
 * @author mincx
 * @version CommonReponse.java v0.1
 * @time 2017-9-19 15:43:32
 */
public class CommonResponse implements Serializable {
	private static final long serialVersionUID = -8737351878134480646L;

	/**
	 * 操作状态
	 */
	@ApiModelProperty(required=true,value="操作状态")
	private String result;

	/**
	 * 操作状态
	 */
	@ApiModelProperty(required=true,value="状态码")
	private int status;

	/**
	 * 数据
	 */
	@ApiModelProperty(required=false,value="数据")
	private Object dataList;

	/**
	 * 操作详细信息
	 */
	@ApiModelProperty(required=false,value="操作详细信息")
	private String message;
	
    public CommonResponse(){

    }
    
    public CommonResponse(String result) {
		this.result = result;
	}

	public CommonResponse(Object dataList) {
		this.dataList = dataList;
		this.result = "";
	}

	public CommonResponse(String result, Object dataList) {
		this.dataList = dataList;
		this.result = result;
	}

	public CommonResponse(String result, String message) {
		this.result = result;
		this.message = message;
	}

	public CommonResponse(String result, Object dataList, String message) {
		this.dataList = dataList;
		this.result = result;
		this.message = message;
	}

	public CommonResponse(String result, Object dataList, int status) {
		this.dataList = dataList;
		this.result = result;
		this.status = status;
	}

	public CommonResponse(String result, String message, int status) {
		this.result = result;
		this.message = message;
		this.status = status;
	}

	public CommonResponse(String result, Object dataList, String message, int status) {
		this.dataList = dataList;
		this.result = result;
		this.message = message;
		this.status = status;
	}

    public Boolean isSuccess(){
        return "SUCCESS".equals(getResult());
    }

    public String getResult() {
        return result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Object getDataList() {
        return dataList;
    }

    public void setDataList(Object dataList) {
        this.dataList = dataList;
    }

	public void setStatus(int status) {
		this.status = status;
	}

	public int getStatus() {
		return status;
	}

	public String toJsonStr() throws Exception {
		return JSON.toJSONString(this,SerializerFeature.WriteMapNullValue,SerializerFeature.DisableCircularReferenceDetect,SerializerFeature.SkipTransientField);
	}
}
