package com.yeejoin.amos.boot.module.ymt.api.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.util.Date;

/**
 * 安全追溯-压力管道
 *
 * @author system_generator
 * @date 2023-08-17
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="IdxBizJgTechParamsPipelineDto", description="安全追溯-压力管道")
public class IdxBizJgTechParamsPipelineDto  extends BaseDto {

   private static final long serialVersionUID = 1L;




    @TableField("RECORD")
    private String record;



    @TableField("INSTANCE_ID")
    private String instanceId;

    @TableField("STATUS")
    private String status;

    @ApiModelProperty(value = "工程(装置)名称")
    @TableField("DEVICE_NAME")
    private String deviceName;

    @ApiModelProperty(value = "管道类别")
    @TableField("PIPELINE_CLASS")
    private String pipelineClass;

    @ApiModelProperty(value = "管道名称（登记单元）")
    @TableField("PIPE_NAME")
    private String pipeName;

    @ApiModelProperty(value = "管道编号")
    @TableField("PIPELINE_NUMBER")
    private String pipelineNumber;

    @ApiModelProperty(value = "设备级别")
    @TableField("DEVICE_LEVEL")
    private String deviceLevel;

    @ApiModelProperty(value = "设计标准")
    @TableField("DESIGN_STANDARD")
    private String designStandard;

    @ApiModelProperty(value = "管道图号")
    @TableField("PIPE_DRAW_NUMBER")
    private String pipeDrawNumber;

    @ApiModelProperty(value = "公称直径")
    @TableField("NOMINAL_DIAMETER")
    private String nominalDiameter;

    @ApiModelProperty(value = "公称壁厚")
    @TableField("WALL_THICKNESS")
    private String wallThickness;

    @ApiModelProperty(value = "管道长度")
    @TableField("PIPE_LENGTH")
    private String pipeLength;

    @ApiModelProperty(value = "起始位置起点")
    @TableField("STARTE_POSITION")
    private String startePosition;

    @ApiModelProperty(value = "压力")
    @TableField("PRESSURE")
    private String pressure;

    @ApiModelProperty(value = "温度")
    @TableField("TEMPERATURE")
    private String temperature;

    @ApiModelProperty(value = "介质")
    @TableField("MEDIUM")
    private String medium;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS")
    private String remarks;

}
