package com.yeejoin.amos.boot.module.ymt.api.entity;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.annotation.FieldDisplayDefine;
import com.yeejoin.amos.boot.biz.common.annotation.Group;
import com.yeejoin.amos.boot.biz.common.entity.TzsBaseEntity;
import com.yeejoin.amos.boot.module.common.api.dto.IBaseChangeData;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * 安全追溯-制造信息
 *
 * @author system_generator
 * @date 2023-08-17
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("idx_biz_jg_factory_info")
@Group(value = "idx_biz_jg_factory_info")
public class IdxBizJgFactoryInfo extends TzsBaseEntity implements IBaseChangeData {



    /**
     *
     */
	@TableField("\"RECORD\"")
    private String record;

    /**
     *
     */
	@TableField("\"INSTANCE_ID\"")
    private String instanceId;

    /**
     *
     */
	@TableField("\"STATUS\"")
    private String status;

    /**
     *
     */
	@TableField("\"PRODUCE_UNIT_CREDIT_CODE\"")
    @FieldDisplayDefine(value = "制造单位统一社会信用代码")
    private String produceUnitCreditCode;

    /**
     *
     */
	@TableField("\"PRODUCE_UNIT_NAME\"")
    @FieldDisplayDefine(value = "制造单位名称")
    private String produceUnitName;

    /**
     *
     */
	@TableField("\"PRODUCE_LICENSE_NUM\"")
    @FieldDisplayDefine(value = "制造许可编号")
    private String produceLicenseNum;

    /**
     *
     */
	@TableField("\"FACTORY_NUM\"")
    @FieldDisplayDefine(value = "出厂编号/产品编号")
    private String factoryNum;

    /**
     *
     */
	@TableField("\"PRODUCE_DATE\"")
    @FieldDisplayDefine(value = "制造日期")
    private Date produceDate;

    /**
     *
     */
	@TableField("\"IMPORTED\"")
    @FieldDisplayDefine(value = "是否进口", typeHandler = "yesOrNoTypeHandler")
    private String imported;

    /**
     *
     */
	@TableField("\"PRODUCE_COUNTRY\"")
    @FieldDisplayDefine(value = "制造国")
    private String produceCountry;

    /**
     *
     */
	@TableField("\"FACTORY_STANDARD\"")
    @FieldDisplayDefine(value = "制造标准", type = JSON.class)
    private String factoryStandard;

    /**
     *
     */
	@TableField("\"PRODUCT_QUALITY_YIELD_PROVE\"")
    @FieldDisplayDefine(value = "产品质量合格证", type = JSON.class)
    private String productQualityYieldProve;

    /**
     *
     */
	@TableField("\"INS_USE_MAINTAIN_EXPLAIN\"")
    @FieldDisplayDefine(value = "安装及使用维护保养说明", type = JSON.class)
    private String insUseMaintainExplain;

    /**
     *
     */
	@TableField("\"SUPERVISION_AGENCY_CREDENTIAL\"")
    private String supervisionAgencyCredential;

    /**
     *
     */
	@TableField("\"TYPE_TEST_CREDENTIAL\"")
    private String typeTestCredential;

    /**
     * 其他附件
     */
	@TableField("\"OTHER_ACCESSORIES_FACT\"")
    private String otherAccessoriesFact;



    /**
     *  	 * 制造监督检验报告
     *      */

    @TableField(value = "\"FACT_SUPERVISION_INSPECTION_REPORT\"")
    @FieldDisplayDefine(value = "制造监督检验报告", type = JSON.class)
    private String factSupervisionInspectionReport;


    /**
     * * 锅炉能效证明文件
     */

    @TableField(value = "\"BOILER_ENERGY_EFFICIENCY_CERTIFICATE\"")
    @FieldDisplayDefine(value = "锅炉能效证明文件", type = JSON.class)
    private String boilerEnergyEfficiencyCertificate;


    /**
     * 资料是否完整齐全：1-齐全；2-不齐全【历史无证设备需要】
     */
    @TableField("\"FACTORY_IS_COMPLETE\"")
    @FieldDisplayDefine(value = "制造资料是否完整齐全", typeHandler = "isCompleteTypeHandler")
    private String factoryIsComplete;

}
