package com.yeejoin.amos.boot.module.ymt.api.entity;

import java.util.Date;

import org.typroject.tyboot.core.rdbms.orm.entity.BaseEntity;

import com.baomidou.mybatisplus.annotation.TableName;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * 人员数据信息-资质信息
 *
 * @author duanwei
 * @date 2022-07-26
 */
@Data
@Accessors(chain = true)
@TableName("tz_jg_staff_qualif_info")
@ApiModel(value = "TzsJgStaffQualifInfo对象", description = "人员数据信息-资质信息")
public class TzsJgStaffQualifInfo extends BaseEntity {

	private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "作业人员身份证号")
	private String operatorId;

	@ApiModelProperty(value = "作业项目名称")
	private String operationItem;

	@ApiModelProperty(value = "作业项目代号")
	private String operationItemCode;

	@ApiModelProperty(value = "有效日期")
	private Date effectiveDate;

	@ApiModelProperty(value = "发证机关")
	private String issuingAuthor;

	@ApiModelProperty(value = "同步时间")
	private Date syncDate;

	@ApiModelProperty(value = "同步状态（0-新增   1-更新   2-删除）")
	private Integer syncState;

	@ApiModelProperty(value = "对接公司编码")
	private String appId;

}
