package com.yeejoin.amos.boot.module.ys.api.dto;

import com.alibaba.fastjson.JSONArray;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 应急演练记录管理
 *
 * @author system_generator
 * @date 2024-09-24
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "YsEmergencyRehearsalDto", description = "应急演练记录管理")
public class YsEmergencyRehearsalDto extends BaseDto {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "关联对象id")
    private String businessId;

    @ApiModelProperty(value = "关联对象类型")
    private String type;

    @ApiModelProperty(value = "演练地点")
    private String rehearsalAddress;

    @ApiModelProperty(value = "演练概述")
    private String rehearsalContent;

    @ApiModelProperty(value = "演练时间")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date rehearsalTime;

    @ApiModelProperty(value = "演练文件")
    private JSONArray rehearsalFile;

    @ApiModelProperty(value = "创建时间")
    private Date createDate;

    @ApiModelProperty(value = "创建人id ")
    private String createUserId;

    @ApiModelProperty(value = "创建人")
    private String createUserName;

}
