package ${package.Controller};
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import com.yeejoin.precontrol.common.entity.publics.CommonResponse;
import org.apache.commons.lang3.StringUtils;
<#if restControllerStyle>
    import org.springframework.web.bind.annotation.RestController;
<#else>
    import org.springframework.stereotype.Controller;
</#if>
<#if superControllerClassPackage??>
    import ${superControllerClassPackage};
</#if>

import ${package.Service}.${table.serviceName};

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import ${package.Entity}.${entity};
import com.yeejoin.precontrol.common.utils.NameUtils;
import java.lang.reflect.Field;
import java.util.Arrays;


/**
* ${table.comment!}
*
* @author ${author}
* @date ${date}
*/
<#if restControllerStyle>
    @RestController
    @Api(tags = "${table.comment}Api")
<#else>
    @Controller
</#if>
@RequestMapping(value = "<#if package.ModuleName??>/${package.ModuleName}</#if>/<#if controllerMappingHyphenStyle??>${controllerMappingHyphen}<#else>${table.entityPath}</#if>", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
<#if kotlin>
    class ${table.controllerName}<#if superControllerClass??> : ${superControllerClass}()</#if>
<#else>
    <#if superControllerClass??>
        public class ${table.controllerName} extends ${superControllerClass} {
    <#else>
        public class ${table.controllerName} {
    </#if>

    @Autowired
    ${table.serviceName} ${table.serviceName ?uncap_first};


    /**
    * 新增${table.comment}
    * @return
    */
    @RequestMapping(value = "/save", method = RequestMethod.POST)
    @ApiOperation(httpMethod = "POST", value = "新增${table.comment}", notes = "新增${table.comment}")
    public boolean save${entity}(HttpServletRequest request, @RequestBody ${entity} ${entity ?uncap_first}){
    return ${table.serviceName ?uncap_first}.save(${entity ?uncap_first});
    }

    /**
    * 根据id删除
    * @param id
    * @return
    */
    @RequestMapping(value = "/{id}", method = RequestMethod.DELETE)
    @ApiOperation(httpMethod = "DELETE", value = "根据id删除", notes = "根据id删除")
    public boolean deleteById(HttpServletRequest request, @PathVariable Long id){
    return ${table.serviceName ?uncap_first}.removeById(id);
    }




    /**
    * 修改${table.comment}
    * @return
    */
    @RequestMapping(value = "/updateById", method = RequestMethod.PUT)
    @ApiOperation(httpMethod = "PUT", value = "修改${table.comment}", notes = "修改${table.comment}")
    public boolean updateById${entity}(HttpServletRequest request, @RequestBody ${entity} ${entity ?uncap_first}){
    return ${table.serviceName ?uncap_first}.updateById(${entity ?uncap_first});
    }



    /**
    * 根据id查询
    * @param id
    * @return
    */
    @RequestMapping(value = "/{id}", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "根据id查询", notes = "根据id查询")
    public ${entity} selectById(HttpServletRequest request, @PathVariable Long id){
    return ${table.serviceName ?uncap_first}.getById(id);
    }



    /**
    * 列表分页查询
    * @return
    */
    @RequestMapping(value = "/list", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "列表分页查询", notes = "列表分页查询")
    public IPage<${entity}> listPage(String pageNum,String pageSize,
    ${entity} ${entity ?uncap_first}){

    Page<${entity}> pageBean;
    QueryWrapper<${entity}> ${entity ?uncap_first}QueryWrapper = new QueryWrapper<>();
    Class<? extends ${entity}> aClass = ${entity ?uncap_first}.getClass();
    Arrays.stream(aClass.getDeclaredFields()).forEach(field -> {
    try {
    field.setAccessible(true);
    Object o = field.get(${entity ?uncap_first});
    if (o != null) {
    Class<?> type = field.getType();
    String name = NameUtils.camel2Underline(field.getName());
    if (type.equals(Integer.class)) {
    Integer fileValue = (Integer) field.get(${entity ?uncap_first});
    ${entity ?uncap_first}QueryWrapper.eq(name, fileValue);
    } else if (type.equals(Long.class)) {
    Long fileValue = (Long) field.get(${entity ?uncap_first});
    ${entity ?uncap_first}QueryWrapper.eq(name, fileValue);
    } else if (type.equals(String.class)) {
    String fileValue = (String) field.get(${entity ?uncap_first});
    ${entity ?uncap_first}QueryWrapper.eq(name, fileValue);
    } else {
    String fileValue = (String) field.get(${entity ?uncap_first});
    ${entity ?uncap_first}QueryWrapper.eq(name, fileValue);
    }
    }
    }catch (Exception e) {
    }
    });
    IPage<${entity}> page;
    if (StringUtils.isBlank(pageNum)  ||StringUtils.isBlank(pageSize)) {
    pageBean = new Page<>(0, Long.MAX_VALUE);
    }else{
    pageBean = new Page<>(Integer.parseInt(pageNum), Integer.parseInt(pageSize));
    }
    page = ${table.serviceName ?uncap_first}.page(pageBean, ${entity ?uncap_first}QueryWrapper);
    return page;
    }
    }


</#if>
