package com.yeejoin.amos.boot.module.elevator.biz.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.boot.module.elevator.api.common.BizCommonConstant;
import com.yeejoin.amos.boot.module.elevator.api.dto.ElevatorDto;
import com.yeejoin.amos.boot.module.elevator.biz.utils.RedisUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.stereotype.Component;

import java.util.List;

@Component
public class ElevatorAppRunner implements ApplicationRunner {

    @Autowired
    RedisUtil redisUtil;

    @Autowired
    ElevatorServiceImpl elevatorServiceImpl;


    @Override
    public void run(ApplicationArguments args) {
        // 缓存电梯数据
        List<ElevatorDto> list = elevatorServiceImpl.selectExportData(null);
        redisUtil.set(BizCommonConstant.OLD_ELEVATOR_REDIS_KEY, JSONObject.toJSONString(list));
    }
}
