package com.yeejoin.amos.boot.module.elevator.flc.biz.controller;

import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import java.util.List;
import com.yeejoin.amos.boot.module.elevator.flc.biz.service.impl.CylinderFillingUnloadDataUnitServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.elevator.flc.api.dto.CylinderFillingUnloadDataUnitDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 气瓶充卸统计表-企业
 *
 * @author system_generator
 * @date 2022-03-11
 */
@RestController
@Api(tags = "气瓶充卸统计表-企业Api")
@RequestMapping(value = "/cylinder-filling-unload-data-unit")
public class CylinderFillingUnloadDataUnitController extends BaseController {

    @Autowired
    CylinderFillingUnloadDataUnitServiceImpl cylinderFillingUnloadDataUnitServiceImpl;

    /**
     * 新增气瓶充卸统计表-企业
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增气瓶充卸统计表-企业", notes = "新增气瓶充卸统计表-企业")
	public ResponseModel<CylinderFillingUnloadDataUnitDto> save(@RequestBody CylinderFillingUnloadDataUnitDto model) {
	    model = cylinderFillingUnloadDataUnitServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新气瓶充卸统计表-企业", notes = "根据sequenceNbr更新气瓶充卸统计表-企业")
	public ResponseModel<CylinderFillingUnloadDataUnitDto> updateBySequenceNbrCylinderFillingUnloadDataUnit(@RequestBody CylinderFillingUnloadDataUnitDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(cylinderFillingUnloadDataUnitServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除气瓶充卸统计表-企业", notes = "根据sequenceNbr删除气瓶充卸统计表-企业")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(cylinderFillingUnloadDataUnitServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个气瓶充卸统计表-企业",  notes = "根据sequenceNbr查询单个气瓶充卸统计表-企业")
	public ResponseModel<CylinderFillingUnloadDataUnitDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(cylinderFillingUnloadDataUnitServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "气瓶充卸统计表-企业分页查询",  notes = "气瓶充卸统计表-企业分页查询")
	public ResponseModel<Page<CylinderFillingUnloadDataUnitDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size) {
	    Page<CylinderFillingUnloadDataUnitDto> page = new Page<CylinderFillingUnloadDataUnitDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(cylinderFillingUnloadDataUnitServiceImpl.queryForCylinderFillingUnloadDataUnitPage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "气瓶充卸统计表-企业列表全部数据查询",   notes = "气瓶充卸统计表-企业列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<CylinderFillingUnloadDataUnitDto>> selectForList() {
	    return ResponseHelper.buildResponse(cylinderFillingUnloadDataUnitServiceImpl.queryForCylinderFillingUnloadDataUnitList());
	}
}
