package com.yeejoin.amos.boot.module.tcm.biz.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.tcm.api.dto.TzsUserInfoDto;
import com.yeejoin.amos.boot.module.tcm.api.entity.TzsUserInfo;
import com.yeejoin.amos.boot.module.tcm.api.entity.TzsUserQualifications;
import com.yeejoin.amos.boot.module.tcm.api.service.ITzsUserInfoService;
import com.yeejoin.amos.boot.module.tcm.biz.service.impl.TzsUserInfoServiceImpl;
import com.yeejoin.amos.component.feign.utils.FeignUtil;
import com.yeejoin.amos.feign.privilege.Privilege;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.amos.feign.privilege.model.CompanyModel;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.Date;
import java.util.List;
import java.util.Map;

@RestController
@Api(tags = "用户信息Api")
@RequestMapping(value = "/userInfo")
public class TzsUserInfoController extends BaseController {

    @Autowired
    private TzsUserInfoServiceImpl tzsUserInfoServiceImpl;

    @Autowired
    private ITzsUserInfoService tzsUserInfoService;


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/save")
    @ApiOperation(httpMethod = "POST", value = "新增人员信息", notes = "新增人员信息")
    public ResponseModel<TzsUserInfoDto> save(@RequestBody JSONObject map) {
        Map<String, Object> userInfo = (Map<String, Object>)map.get("userInfo");
        TzsUserInfoDto tzsUserInfo = JSON.parseObject(JSON.toJSONString(userInfo), TzsUserInfoDto.class);
        List<CompanyModel> companyModels = FeignUtil.remoteCall(()->Privilege.companyClient.queryListByChild(RequestContext.getExeUserId()));
        if(companyModels.isEmpty()){
            throw new BadRequest("未指定人员归属单位信息");
        }
        tzsUserInfo.setUnitName(companyModels.get(0).getCompanyName());
        tzsUserInfo.setUnitCode(companyModels.get(0).getCompanyCode());
        tzsUserInfo.setRecDate(new Date());
        Map<String, Object> qualificationsInfo = (Map<String, Object>)map.get("qualificationsInfo");
        Object subForm = qualificationsInfo.get("subForm");
        List<TzsUserQualifications> list = JSON.parseArray(JSON.toJSONString(subForm), TzsUserQualifications.class);
        tzsUserInfo.setPostName(tzsUserInfoServiceImpl.setPostName(tzsUserInfo.getPost()));
        tzsUserInfo = tzsUserInfoServiceImpl.createWithModel(tzsUserInfo);
        if (!ObjectUtils.isEmpty(list)){
            tzsUserInfoService.addQualificationsMessage(String.valueOf(tzsUserInfo.getSequenceNbr()),list);
        }
        return ResponseHelper.buildResponse(tzsUserInfo);
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/update")
    @ApiOperation(httpMethod = "POST", value = "修改人员信息", notes = "修改人员信息")
    public ResponseModel<TzsUserInfo> update(@RequestBody JSONObject map,
                                             @RequestParam Long rowId) {
        Map<String, Object> userInfo = (Map<String, Object>)map.get("userInfo");
        TzsUserInfo tzsUserInfo = JSON.parseObject(JSON.toJSONString(userInfo), TzsUserInfo.class);
        List<CompanyModel> companyModels = FeignUtil.remoteCall(()->Privilege.companyClient.queryListByChild(RequestContext.getExeUserId()));
        if(companyModels.isEmpty()){
            throw new BadRequest("未指定人员归属单位信息");
        }
        tzsUserInfo.setUnitName(companyModels.get(0).getCompanyName());
        tzsUserInfo.setUnitCode(companyModels.get(0).getCompanyCode());
        Map<String, Object> qualificationsInfo = (Map<String, Object>)map.get("qualificationsInfo");
        Object subForm = qualificationsInfo.get("subForm");
        List<TzsUserQualifications> list = JSON.parseArray(JSON.toJSONString(subForm), TzsUserQualifications.class);
        tzsUserInfo.setSequenceNbr(rowId);
        tzsUserInfo.setRecDate(new Date());
        tzsUserInfo.setPostName(tzsUserInfoServiceImpl.setPostName(tzsUserInfo.getPost()));
        tzsUserInfoServiceImpl.updateById(tzsUserInfo);
        if (!ObjectUtils.isEmpty(list)){
            tzsUserInfoService.updateQualificationsMessage(String.valueOf(tzsUserInfo.getSequenceNbr()),list);
        }
        return ResponseHelper.buildResponse(tzsUserInfo);
    }



    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/deleteBatch")
    @ApiOperation(httpMethod = "POST", value = "批量删除", notes = "批量删除")
    public ResponseModel<Object> deleteBatch(@RequestBody JSONObject map) {
        List<Long> ids = (List<Long>) map.get("ids");
        tzsUserInfoService.deleteBatch(ids);
        return ResponseHelper.buildResponse("ok");
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/getDetail")
    @ApiOperation(httpMethod = "GET", value = "详情", notes = "详情")
    public ResponseModel<Map<String, Object>> queryForPage(@RequestParam(value = "id") Long id) {
        return ResponseHelper.buildResponse(tzsUserInfoService.getDetail(id));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/page")
    @ApiOperation(httpMethod = "GET", value = "人员信息列表", notes = "人员信息列表")
    public ResponseModel<IPage<TzsUserInfoDto>> queryForPage(@RequestParam(value = "current") String current,
                                                             @RequestParam(value = "size") String size,
                                                             TzsUserInfoDto dto) {

        List<CompanyModel> companyModels = FeignUtil.remoteCall(()->Privilege.companyClient.queryListByChild(RequestContext.getExeUserId()));
        if(companyModels.isEmpty()){
            throw new BadRequest("未指定人员归属单位信息");
        }
        dto.setUnitCode(companyModels.get(0).getCompanyCode());
        Page<TzsUserInfoDto> page = new Page<>();
        page.setCurrent(Long.parseLong(current));
        page.setSize(Long.parseLong(size));
        return ResponseHelper.buildResponse(tzsUserInfoService.page(dto,page));
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/BindAccount")
    @ApiOperation(httpMethod = "POST", value = "人员绑定用户", notes = "人员绑定用户")
    public ResponseModel<Boolean> BindAccount(@RequestBody Map<String, Object> map) {
        return ResponseHelper.buildResponse(tzsUserInfoService.BindAccount(map));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/startOrStopAccount")
    @ApiOperation(httpMethod = "POST", value = "启用或者停用账户", notes = "启用或者停用账户")
    public ResponseModel<String> startOrStopAccount(@RequestBody Map<String, Object> map) {
        return ResponseHelper.buildResponse(tzsUserInfoService.startOrStopAccount(map));
    }
}
