package com.yeejoin.amos.boot.module.ymt.biz.config;

import lombok.extern.slf4j.Slf4j;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;


@Configuration
@Slf4j
public class RedissonManager {



    //集群环境使用
//    @Value("${spring.redis.cluster.nodes}")
//    private String clusterNodes;

    //通用
    @Value("${spring.redis.password}")
    private String password;

    //单机环境使用
    @Value("${spring.redis.host}")
    private String host;
    //单机环境使用
    @Value("${spring.redis.port}")
    private String port;




    @Bean
    public RedissonClient redissonClient() {
        //集群环境使用
//        log.info("clusterNodes{}",clusterNodes);
//        log.info("password{}",password);
//
//        Config config = new Config();
//        config.useClusterServers()
//                .addNodeAddress(clusterNodes.split(","))
//                .setPassword(password);
//        return Redisson.create(config);

        //单机打包使用
        Config config = new Config();
        config.useSingleServer().setAddress(host + ":" + port).setPassword(password);
        return Redisson.create(config);
    }
}
