package com.yeejoin.amos.boot.module.jg.api.enums;

import lombok.Getter;

/**
 * 业务类型枚举
 * 枚举code需同字典表中问题类型（type=ISSUE_TYPE）code保持一致
 *
 * @author Administrator
 */
@Getter
public enum SafetyProblemTypeEnum {

    /**
     * 问题类型枚举
     */
    JYCQ("2", "检验超期", "设备检验超期", "safetyProblemTracing/jy/cq", "outOfInspectionRecords"),
    JYBJ("21", "检验报检", "设备报检", "safetyProblemTracing/jy/bj", null),
    WBCQ("1", "维保超期", "设备维保超期", "safetyProblemTracing/wb/cq", "outOfMaintenanceRecords"),
    WBBA("11", "维保合同备案", "设备维保合同备案", "safetyProblemTracing/wb/ba", null),
    XKCQ("3", "许可超期", "企业许可超期", "safetyProblemTracing/xk/cq", null),
    ZZCQ("9", "资质超期", "人员资质超期", "safetyProblemTracing/zz/cq", null),
    SJNXCQ("5", "超设计年限", "设备超设计年限", "safetyProblemTracing/synx/cq", null),
    SJNXDJ("51", "超设计年限登记", "超设计年限登记", "safetyProblemTracing/synx/dj", null);

    private final String code;

    private final String name;

    private final String desc;

    private final String topic;

    /**
     * 消息对象属性
     * */
    private final String msgKey;

    SafetyProblemTypeEnum(String code, String name, String desc, String topic, String msgKey) {
        this.code = code;
        this.name = name;
        this.desc = desc;
        this.topic = topic;
        this.msgKey = msgKey;
    }

    public static String getNameByType(String code) {
        String name = null;
        for (SafetyProblemTypeEnum enumOne : SafetyProblemTypeEnum.values()) {
            if (enumOne.getCode().equals(code)) {
                name = enumOne.getName();
                break;
            }
        }
        return name;
    }
}
