package com.yeejoin.amos.boot.module.jg.biz.service;

import com.yeejoin.amos.boot.module.jg.api.dto.ChangeDataDto;
import com.yeejoin.amos.boot.module.jg.api.service.IBizDataChangeHandleStrategy;

import java.util.List;
import java.util.Map;

/**
 * 事件处理监听器，将前端数据解析为java对象格式
 */
public interface IChangeDataProcessStrategy {

    /**
     * 事件处理
     */
    List<ChangeDataDto> handle(Map<String, Object> changeData, String defaultChangeId);


    Map<String, Object> getDetail(String applyNo, String bizId);

    /**
     * 可处理类型
     *
     * @return 可处理的事件
     */
    IBizDataChangeHandleStrategy.ModelType canHandleMode();
}
