package com.yeejoin.amos.api.openapi.face.orm.dao;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yeejoin.amos.api.openapi.face.orm.entity.MidEquipRegistrationInfo;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;
import java.util.Set;

/**
 * 特种设备基本信息-注册登记信息  Mapper 接口
 *
 * @author Zhang Yingbin
 * @date 2022-07-19
 */
public interface MidEquipRegistrationInfoMapper extends BaseMapper<MidEquipRegistrationInfo> {

    @DS("tzs")
    @Select("<script>" +
            "SELECT DISTINCT sequenceCode FROM " +
            "(SELECT concat ( fi.\"PRODUCE_UNIT_CREDIT_CODE\", '-', fi.\"FACTORY_NUM\" ) sequenceCode " +
            "FROM idx_biz_jg_factory_info fi, idx_biz_jg_other_info oi " +
            "WHERE oi.\"RECORD\" = fi.\"RECORD\" " +
            " AND oi.\"CLAIM_STATUS\" = '已认领' " +
            " AND fi.\"PRODUCE_UNIT_CREDIT_CODE\" IS NOT NULL " +
            " AND fi.\"FACTORY_NUM\" IS NOT NULL) WHERE sequenceCode in " +
            "<foreach item='item' index='index' collection='sequenceCodes' open='(' separator=',' close=')'>" +
            "  #{item}" +
            "</foreach>" +
            "</script>")
    List<String> getUsedCountBySeqCodes(@Param("sequenceCodes") Set<String> sequenceCodes);
}
