package com.yeejoin.amos.api.openapi.face.service;


import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.api.openapi.face.model.TmCylinderOffloadingModel;
import com.yeejoin.amos.api.openapi.face.orm.dao.TmCylinderOffloadingMapper;
import com.yeejoin.amos.api.openapi.face.orm.entity.TmCylinderOffloading;
import com.yeejoin.amos.api.openapi.service.MyBaseServiceImpl;
import com.yeejoin.amos.api.openapi.util.MultiFieldKey;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.typroject.tyboot.core.foundation.utils.Bean;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;

import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;


/**
 * <pre>
 *  气站卸液量记录表 服务类
 * </pre>
 *
 * @author gwb
 * @version $Id: TmCylinderOffloadingService.java, v 0.1 2024年7月5日 下午3:28:55 tb Exp $
 */
@Component
@Slf4j
public class TmCylinderOffloadingService extends MyBaseServiceImpl<TmCylinderOffloadingModel, TmCylinderOffloading, TmCylinderOffloadingMapper> {

    @Autowired
    private SyncCylinderDataService syncCylinderDataService;

    @DSTransactional
    public String createCylinderOffloading(List<TmCylinderOffloadingModel> model) {
        if (ValidationUtil.isEmpty(model))
            throw new BadRequest("气站卸液量信息数据为空.");
        String appId = getAppId();
        Date now = new Date();

        for (TmCylinderOffloadingModel tmCylinderOffloadingModel : model) {
            tmCylinderOffloadingModel.setSequenceNbr(null);
            tmCylinderOffloadingModel.setRecDate(now);
            tmCylinderOffloadingModel.setAppId(appId);
            LocalDate localDate = tmCylinderOffloadingModel.getSyncDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();

            tmCylinderOffloadingModel.setStatisticsSyncDate(localDate);
        }
        // 同步到业务库
        syncCylinderOffloadingModel(model);

        List<TmCylinderOffloading> tmCylinderOffloadingList = Bean.toModels(model, TmCylinderOffloading.class);
        this.saveOrUpdateBatchByUniqueFields(
                tmCylinderOffloadingList,
                tmCylinderOffloading -> new LambdaQueryWrapper<TmCylinderOffloading>()
                        .eq(TmCylinderOffloading::getCreditCode, tmCylinderOffloading.getCreditCode())
                        .eq(TmCylinderOffloading::getStatisticsSyncDate, tmCylinderOffloading.getStatisticsSyncDate()),
                entity -> new MultiFieldKey(entity.getCreditCode(), entity.getStatisticsSyncDate()),
                "creditCode", "statisticsSyncDate");

        return "OK";
    }

    /**
     * 同步气站信息至气瓶服务
     * @param model
     */
    private void syncCylinderOffloadingModel(List<TmCylinderOffloadingModel> model) {
        syncCylinderDataService.syncCylinderOffloading(model);
    }
}
