package com.yeejoin.amos.boot.module.jg.biz.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.IdxBizJgProjectContraptionServiceImpl;
import com.yeejoin.amos.boot.module.ymt.api.dto.IdxBizJgProjectContraptionDto;
import com.yeejoin.amos.boot.module.ymt.api.entity.IdxBizJgProjectContraption;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;
import java.util.Map;

/**
 * 管道工程装置表
 *
 * @author system_generator
 * @date 2024-12-11
 */
@RestController
@Api(tags = "管道工程装置表Api")
@RequestMapping(value = "/idx-biz-jg-project-contraption")
public class IdxBizJgProjectContraptionController extends BaseController {

    @Autowired
	IdxBizJgProjectContraptionServiceImpl idxBizJgProjectContraptionServiceImpl;

    /**
     * 新增管道工程装置表
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增管道工程装置表", notes = "新增管道工程装置表")
	public ResponseModel<IdxBizJgProjectContraptionDto> save(@RequestBody IdxBizJgProjectContraptionDto model) {
	    model = idxBizJgProjectContraptionServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新管道工程装置表", notes = "根据sequenceNbr更新管道工程装置表")
	public ResponseModel<IdxBizJgProjectContraptionDto> updateBySequenceNbrIdxBizJgProjectContraption(@RequestBody IdxBizJgProjectContraptionDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(idxBizJgProjectContraptionServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除管道工程装置表及设备信息", notes = "根据sequenceNbr删除管道工程装置表及设备信息")
	public ResponseModel<Boolean> deleteBySequenceNbr(@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
		return ResponseHelper.buildResponse(idxBizJgProjectContraptionServiceImpl.deleteProjectAndEquInfoBySeq(sequenceNbr));
    }

	/**
	 * 根据入参 分页查询（当前）单位下的工程管道
	 *
	 * @param params  - isIntoManagement 是否是否纳管 true/false
	 *                - useRegistrationCode 使用登记编号 string()
	 *                - regCodeIsNull 使用登记编号是否为空 true/false
	 * @param current 当前页
	 * @param size    每页大小
	 * @return result
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/pageByParams")
	@ApiOperation(httpMethod = "GET", value = "根据入参 分页查询（当前）单位下的工程管道", notes = "根据入参 分页查询（当前）单位下的工程管道")
	public ResponseModel<IPage<IdxBizJgProjectContraption>> proConPageByParams(
			@RequestParam Map<String, String> params,
			@RequestParam(value = "current") int current,
			@RequestParam(value = "size") int size) {
		Page<IdxBizJgProjectContraption> page = new Page<>();
		page.setCurrent(current);
		page.setSize(size);
		ReginParams reginParams = getSelectedOrgInfo();
		return ResponseHelper.buildResponse(idxBizJgProjectContraptionServiceImpl.proConPageByParams(params, page, reginParams));
	}

	/**
	 * 根据入参 列表查询（当前）单位下的工程管道
	 *
	 * @param params - isIntoManagement 是否是否纳管 true/false
	 *               - useRegistrationCode 使用登记编号 string()
	 *               - regCodeIsNull 使用登记编号是否为空 true/false
	 * @return result
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/listByParams")
	@ApiOperation(httpMethod = "GET", value = "根据入参 列表查询（当前）单位下的工程管道", notes = "根据入参 列表查询（当前）单位下的工程管道")
	public ResponseModel<List<IdxBizJgProjectContraption>> proConListByParams(@RequestParam Map<String, String> params) {
		ReginParams reginParams = getSelectedOrgInfo();
		return ResponseHelper.buildResponse(idxBizJgProjectContraptionServiceImpl.proConListByParams(params, reginParams));
	}

	/**
	 * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个管道工程装置表",  notes = "根据sequenceNbr查询单个管道工程装置表")
	public ResponseModel<IdxBizJgProjectContraptionDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(idxBizJgProjectContraptionServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "管道工程装置表分页查询",  notes = "管道工程装置表分页查询")
	public ResponseModel<Page<IdxBizJgProjectContraptionDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size) {
	    Page<IdxBizJgProjectContraptionDto> page = new Page<IdxBizJgProjectContraptionDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(idxBizJgProjectContraptionServiceImpl.queryForIdxBizJgProjectContraptionPage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "管道工程装置表列表全部数据查询",   notes = "管道工程装置表列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<IdxBizJgProjectContraptionDto>> selectForList() {
	    return ResponseHelper.buildResponse(idxBizJgProjectContraptionServiceImpl.queryForIdxBizJgProjectContraptionList());
	}
}
