package com.yeejoin.amos.boot.module.jg.biz.controller;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.common.biz.utils.CommonResponseUtil;
import com.yeejoin.amos.boot.module.jg.api.dto.JgInstallationNoticeDto;
import com.yeejoin.amos.boot.module.jg.api.entity.JgInstallationNotice;
import com.yeejoin.amos.boot.module.jg.api.service.IJgInstallationNoticeService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.component.event.RestEventTrigger;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletResponse;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

/**
 * 安装告知
 *
 * @author system_generator
 * @date 2023-12-12
 */
@RestController
@Api(tags = "安装告知Api")
@RequestMapping(value = "/jg-installation-notice")
public class JgInstallationNoticeController extends BaseController {

    @Autowired
    private IJgInstallationNoticeService iJgInstallationNoticeService;

    /**
     * 新增
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/save")
    @ApiOperation(httpMethod = "POST", value = "新增安装告知", notes = "新增安装告知")
    @RestEventTrigger(value = "operateLogRestEventHandler")
    public ResponseModel<String> save(@RequestParam String submitType, @RequestBody JSONObject model) {
        ReginParams reginParams = getSelectedOrgInfo();

        iJgInstallationNoticeService.saveNotice(submitType, model, reginParams);
        return ResponseHelper.buildResponse("");
    }

    /**
     * 根据sequenceNbr更新
     *
     * @param model 安装告知
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PutMapping(value = "/update")
    @ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新安装告知", notes = "根据sequenceNbr更新安装告知")
    @RestEventTrigger(value = "operateLogRestEventHandler")
    public ResponseModel<JgInstallationNoticeDto> updateBySequenceNbrJgInstallationNotice(@RequestParam String submitType, @RequestBody Map<String, Object> model, @RequestParam(value = "op", required = false) String op) {
        JgInstallationNoticeDto installationInfo = BeanUtil.mapToBean(((LinkedHashMap) model.get("installationInfo")), JgInstallationNoticeDto.class, true);
        if (Objects.isNull(installationInfo)) {
            throw new IllegalArgumentException("参数installationInfo不能为空");
        }
        return ResponseHelper.buildResponse(iJgInstallationNoticeService.updateInstallationNotice(submitType, installationInfo, op));
    }

    /**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/delete")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除安装告知", notes = "根据sequenceNbr删除安装告知")
    public ResponseModel<Boolean> deleteBySequenceNbr(@RequestParam(value = "sequenceNbr") Long sequenceNbr) {
        iJgInstallationNoticeService.deleteForBatch(new Long[]{sequenceNbr});
        return ResponseHelper.buildResponse(Boolean.TRUE);
    }

    /**
     * 根据sequenceNbr批量删除
     *
     * @param sequenceNbrs 主键
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/batchDelete")
    @ApiOperation(value = "根据sequenceNbr删除维保合同备案", notes = "根据sequenceNbr删除维保合同备案")
    public ResponseModel<Boolean> deleteForBatch(@RequestParam("sequenceNbrs") Long[] sequenceNbrs) {
        try {
            return ResponseHelper.buildResponse(iJgInstallationNoticeService.deleteForBatch(sequenceNbrs));
        } catch (Exception e) {
            return CommonResponseUtil.failure(e.getMessage());
        }
    }

    /**
     * 根据sequenceNbr查询
     *
     * @param sequenceNbr 主键
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/details")
    @ApiOperation(httpMethod = "GET", value = "根据sequenceNbr查询单个安装告知", notes = "根据sequenceNbr查询单个安装告知")
    public ResponseModel<Map<String,
            Map<String, Object>>> selectOne(@RequestParam("sequenceNbr") Long sequenceNbr) {
        String companyLevel = (String) iJgInstallationNoticeService.getCompanyType().get("companyLevel");
        return ResponseHelper.buildResponse(iJgInstallationNoticeService.queryBySequenceNbr(sequenceNbr, companyLevel));
    }


    /**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/page")
    @ApiOperation(httpMethod = "GET", value = "安装告知分页查询", notes = "安装告知分页查询")
    public ResponseModel<Page<Map<String, Object>>> queryForPage(
            @ApiParam(value = "当前页码", required = true)
            @RequestParam(value = "current", defaultValue = "1") int current,
            @ApiParam(value = "每页大小", required = true)
            @RequestParam(value = "size", defaultValue = "20") int size,
            @ApiParam(value = "类型：enterprise-企业端、supervision-监管端", required = true)
            @RequestParam(value = "type", defaultValue = "enterprise") String type,
            @ApiParam(value = "排序字段", required = false)
            @RequestParam(value = "sort", required = false) String sort,
            @RequestBody(required = false) JgInstallationNoticeDto model
    ) {
        Page<JgInstallationNotice> page = new Page<>(current, size);
        ReginParams reginParams = getSelectedOrgInfo();
        type = (String) iJgInstallationNoticeService.getCompanyType().get("companyLevel");
        return ResponseHelper.buildResponse(iJgInstallationNoticeService.queryForJgInstallationNoticePage(page, model, type, sort, reginParams));
    }

    /**
     * 生成告知单
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "安装告知列表全部数据查询", notes = "安装告知列表全部数据查询")
    @GetMapping(value = "/generate-report")
    public void generateReport(HttpServletResponse response, @RequestParam("sequenceNbr") Long sequenceNbr) {
        iJgInstallationNoticeService.generateInstallationNoticeReport(sequenceNbr, response);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "PUT", value = "安装告知单个作废", notes = "安装告知单个作废")
    @PutMapping(value = "/cancel/application")
    @RestEventTrigger(value = "operateLogRestEventHandler")
    public ResponseModel<JgInstallationNotice> cancelApplication(@RequestBody JgInstallationNoticeDto jgInstallationNoticeDto) {
        JgInstallationNotice result = iJgInstallationNoticeService.cancelApplication(jgInstallationNoticeDto.getSequenceNbr(), jgInstallationNoticeDto.getCancelReason());
        return ResponseHelper.buildResponse(result);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "查询工程装置下的所有未做安装告知、不在安装告知流程、安装告知作废的设备",
            notes = "查询工程装置下的所有未做安装告知、不在安装告知流程、安装告知作废的设备")
    @GetMapping(value = "/getDeviceListByProjectContraptionSeq")
    public ResponseModel<Object> getDeviceListByProjectContraption(@RequestParam Map<String, Object> params) {
        String projectContraptionSeq = String.valueOf(params.get("sequenceNbr"));
        return ResponseHelper.buildResponse(iJgInstallationNoticeService.getDeviceListByProjectContraption(projectContraptionSeq));
    }
}
