package com.yeejoin.amos.boot.module.jg.biz.service.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.yeejoin.amos.boot.module.common.api.dao.ESEquipmentCategory;
import com.yeejoin.amos.boot.module.common.api.dto.ESEquipmentCategoryDto;
import com.yeejoin.amos.boot.module.jg.api.dto.*;
import com.yeejoin.amos.boot.module.jg.api.enums.CylinderTypeEnum;
import com.yeejoin.amos.boot.module.jg.api.mapper.CommonMapper;
import com.yeejoin.amos.boot.module.ymt.api.entity.EquipmentCategory;
import com.yeejoin.amos.boot.module.ymt.api.entity.IdxBizJgDesignInfo;
import com.yeejoin.amos.boot.module.ymt.api.entity.IdxBizJgFactoryInfo;
import com.yeejoin.amos.boot.module.ymt.api.entity.IdxBizJgRegisterInfo;
import com.yeejoin.amos.boot.module.ymt.api.enums.EquCodeTypeEnum;
import com.yeejoin.amos.boot.module.ymt.api.mapper.EquipmentCategoryMapper;
import com.yeejoin.amos.boot.module.ymt.api.mapper.IdxBizJgDesignInfoMapper;
import com.yeejoin.amos.boot.module.ymt.api.mapper.IdxBizJgFactoryInfoMapper;
import com.yeejoin.amos.boot.module.ymt.api.mapper.IdxBizJgRegisterInfoMapper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

@Service
public class EquipChangeDataUpdateService {

    private final ESEquipmentCategory esEquipmentCategory;

    private final IdxBizJgDesignInfoMapper idxBizJgDesignInfoMapper;

    private final IdxBizJgFactoryInfoMapper jgFactoryInfoMapper;

    private final IdxBizJgRegisterInfoMapper idxBizJgRegisterInfoMapper;

    private final CommonMapper commonMapper;

    private final EquipmentCategoryMapper equipmentCategoryMapper;

    public EquipChangeDataUpdateService(ESEquipmentCategory esEquipmentCategory, IdxBizJgDesignInfoMapper idxBizJgDesignInfoMapper, IdxBizJgFactoryInfoMapper jgFactoryInfoMapper, IdxBizJgRegisterInfoMapper idxBizJgRegisterInfoMapper, CommonMapper commonMapper, EquipmentCategoryMapper equipmentCategoryMapper) {
        this.esEquipmentCategory = esEquipmentCategory;
        this.idxBizJgDesignInfoMapper = idxBizJgDesignInfoMapper;
        this.jgFactoryInfoMapper = jgFactoryInfoMapper;
        this.idxBizJgRegisterInfoMapper = idxBizJgRegisterInfoMapper;
        this.commonMapper = commonMapper;
        this.equipmentCategoryMapper = equipmentCategoryMapper;
    }

    public void updateRegisterChangeData(String record, EquipRegisterChangeDataDto registerChangeDataDto) {
        LambdaUpdateWrapper<IdxBizJgRegisterInfo> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(IdxBizJgRegisterInfo::getRecord, record);
        updateWrapper.set(IdxBizJgRegisterInfo::getEquCode, registerChangeDataDto.getEquCode());
        updateWrapper.set(IdxBizJgRegisterInfo::getEquDefine, registerChangeDataDto.getEquDefine());
        updateWrapper.set(IdxBizJgRegisterInfo::getProductName, registerChangeDataDto.getProductName());
        updateWrapper.set(IdxBizJgRegisterInfo::getEquType, registerChangeDataDto.getEquType());
        updateWrapper.set(IdxBizJgRegisterInfo::getEquPrice, registerChangeDataDto.getEquPrice());
        updateWrapper.set(IdxBizJgRegisterInfo::getProductPhoto, registerChangeDataDto.getProductPhoto());
        updateWrapper.set(IdxBizJgRegisterInfo::getOtherAccessoriesReg, registerChangeDataDto.getOtherAccessoriesReg());
        idxBizJgRegisterInfoMapper.update(null, updateWrapper);
        updateRegisterEsData(record, registerChangeDataDto);
    }


    public void updateDesignChangeData(String record, EquipDesignChangeDataDto equipDesignChangeDataDto) {
        LambdaUpdateWrapper<IdxBizJgDesignInfo> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(IdxBizJgDesignInfo::getRecord, record);
        updateWrapper.set(IdxBizJgDesignInfo::getDesignDate, StringUtils.isNotEmpty(equipDesignChangeDataDto.getDesignDate()) ? DateUtil.parse(equipDesignChangeDataDto.getDesignDate(), "yyyy-MM-dd") : null);
        updateWrapper.set(IdxBizJgDesignInfo::getDesignDoc, equipDesignChangeDataDto.getDesignDoc());
        updateWrapper.set(IdxBizJgDesignInfo::getDesignUnitCreditCode, equipDesignChangeDataDto.getDesignUnitCreditCode());
        updateWrapper.set(IdxBizJgDesignInfo::getDesignUnitName, equipDesignChangeDataDto.getDesignUnitName());
        updateWrapper.set(IdxBizJgDesignInfo::getDesignUseDate, equipDesignChangeDataDto.getDesignUseDate());
        updateWrapper.set(IdxBizJgDesignInfo::getDesignLicenseNum, equipDesignChangeDataDto.getDesignLicenseNum());
        updateWrapper.set(IdxBizJgDesignInfo::getAppraisalUnit, equipDesignChangeDataDto.getAppraisalUnit());
        updateWrapper.set(IdxBizJgDesignInfo::getOtherAccessoriesDes, equipDesignChangeDataDto.getOtherAccessoriesDes());
        updateWrapper.set(IdxBizJgDesignInfo::getAppraisalDate, equipDesignChangeDataDto.getAppraisalDate());
        updateWrapper.set(IdxBizJgDesignInfo::getDrawingDo, equipDesignChangeDataDto.getDrawingDo());
        updateWrapper.set(IdxBizJgDesignInfo::getDesignStandard, equipDesignChangeDataDto.getDesignStandard());
        idxBizJgDesignInfoMapper.update(null, updateWrapper);
    }

    public void updateFactoryChangeData(String record, EquipFactoryChangeDataDto equipFactoryChangeDataDto) {
        LambdaUpdateWrapper<IdxBizJgFactoryInfo> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(IdxBizJgFactoryInfo::getRecord, record);
        // 影响设备代码的生成
        updateWrapper.set(IdxBizJgFactoryInfo::getProduceDate, StringUtils.isNotEmpty(equipFactoryChangeDataDto.getProduceDate()) ? DateUtil.parse(equipFactoryChangeDataDto.getProduceDate(), "yyyy-MM-dd") : null);
        updateWrapper.set(IdxBizJgFactoryInfo::getProduceUnitName, equipFactoryChangeDataDto.getProduceUnitName());
        updateWrapper.set(IdxBizJgFactoryInfo::getProduceCountry, equipFactoryChangeDataDto.getProduceCountry());
        updateWrapper.set(IdxBizJgFactoryInfo::getProduceUnitCreditCode, equipFactoryChangeDataDto.getProduceUnitCreditCode());
        updateWrapper.set(IdxBizJgFactoryInfo::getProduceLicenseNum, equipFactoryChangeDataDto.getProduceLicenseNum());
        updateWrapper.set(IdxBizJgFactoryInfo::getProductQualityYieldProve, equipFactoryChangeDataDto.getProductQualityYieldProve());
        updateWrapper.set(IdxBizJgFactoryInfo::getFactoryStandard, equipFactoryChangeDataDto.getFactoryStandard());
        updateWrapper.set(IdxBizJgFactoryInfo::getFactoryNum, equipFactoryChangeDataDto.getFactoryNum());
        updateWrapper.set(IdxBizJgFactoryInfo::getFactSupervisionInspectionReport, equipFactoryChangeDataDto.getFactSupervisionInspectionReport());
        updateWrapper.set(IdxBizJgFactoryInfo::getOtherAccessoriesFact, equipFactoryChangeDataDto.getOtherAccessoriesFact());
        updateWrapper.set(IdxBizJgFactoryInfo::getImported, equipFactoryChangeDataDto.getImported());
        updateWrapper.set(IdxBizJgFactoryInfo::getInsUseMaintainExplain, equipFactoryChangeDataDto.getInsUseMaintainExplain());
        updateWrapper.set(IdxBizJgFactoryInfo::getBoilerEnergyEfficiencyCertificate, equipFactoryChangeDataDto.getBoilerEnergyEfficiencyCertificate());
        jgFactoryInfoMapper.update(null, updateWrapper);
        this.updateFactoryEsData(record, equipFactoryChangeDataDto);
    }

    private void updateFactoryEsData(String record, EquipFactoryChangeDataDto equipFactoryChangeDataDto) {
        // es 数据更新
        Optional<ESEquipmentCategoryDto> optional = esEquipmentCategory.findById(record);
        if (optional.isPresent()) {
            ESEquipmentCategoryDto esEquipmentCategoryDto = optional.get();
            esEquipmentCategoryDto.setPRODUCE_DATE(equipFactoryChangeDataDto.getProduceDate());
            esEquipmentCategoryDto.setFACTORY_NUM(equipFactoryChangeDataDto.getFactoryNum());
            esEquipmentCategoryDto.setPRODUCE_UNIT_NAME(equipFactoryChangeDataDto.getProduceUnitName());
            esEquipmentCategory.save(esEquipmentCategoryDto);
        }
    }

    private void updateRegisterEsData(String record, EquipRegisterChangeDataDto registerChangeDataDto) {
        // es 数据更新
        Optional<ESEquipmentCategoryDto> optional = esEquipmentCategory.findById(record);
        if (optional.isPresent()) {
            ESEquipmentCategoryDto esEquipmentCategoryDto = optional.get();
            esEquipmentCategoryDto.setPRODUCT_NAME(registerChangeDataDto.getProductName());
            esEquipmentCategoryDto.setEQU_CODE(registerChangeDataDto.getEquCode());
            esEquipmentCategoryDto.setEQU_TYPE(registerChangeDataDto.getEquType());
            esEquipmentCategoryDto.setEQU_DEFINE_CODE(registerChangeDataDto.getEquDefine());
            if (StringUtils.isEmpty(registerChangeDataDto.getEquDefine())) {
                esEquipmentCategoryDto.setEQU_DEFINE(null);
            } else {
                EquipmentCategory category = getEquipmentCategory(registerChangeDataDto);
                if (category != null) {
                    esEquipmentCategoryDto.setEQU_DEFINE(category.getName());
                }
            }
            esEquipmentCategory.save(esEquipmentCategoryDto);
        }
    }

    private EquipmentCategory getEquipmentCategory(EquipRegisterChangeDataDto registerChangeDataDto) {
        return equipmentCategoryMapper.selectOne(new LambdaQueryWrapper<EquipmentCategory>().eq(EquipmentCategory::getCode, registerChangeDataDto.getEquDefine()));
    }

    public void updateTechParamByRecord(String tableName, String record, List<ChangeDataDto> changeDataDtos) {
        List<DynamicColumnDto> columns = changeDataDtos.stream().map(c -> {
            DynamicColumnDto columnDto = new DynamicColumnDto();
            columnDto.setColumnName(String.format("\"%s\"", StrUtil.toUnderlineCase(c.getColumnKey()).toUpperCase()));
            columnDto.setColumnValue(c.getColumnNewValue());
            return columnDto;
        }).collect(Collectors.toList());
        //  sql 动态构建入库
        commonMapper.updateTechParamDynamic(tableName, record, columns);
    }

    public void checkFactoryChangeData(String record, EquipFactoryChangeDataDto equipFactoryChangeDataDto, String equList, String equCategory, String equDefine) {
        // 气瓶时检验出厂编号-普通气瓶，车用气瓶不再此范围内
        if (CylinderTypeEnum.CYLINDER.getCode().equals(equCategory)) {
            boolean isUsed = this.checkFactoryNumUnique(equipFactoryChangeDataDto.getFactoryNum(), record, equipFactoryChangeDataDto.getProduceUnitCreditCode());
            if (isUsed) {
                throw new BadRequest("出厂编号/产品编码在该企业中已存在！");
            }
        }
    }

    /**
     * 普通气瓶检验-同制造单位下唯一
     *
     * @param factoryNum            出厂编号
     * @param produceUnitCreditCode 制造单位编码
     * @return 是否被占用
     */
    private boolean checkFactoryNumUnique(String factoryNum, String record, String produceUnitCreditCode) {
        return commonMapper.checkFactoryNumUnique(factoryNum, record, produceUnitCreditCode) > 0;
    }


    public void checkRegisterChangeData(String record, EquipRegisterChangeDataDto registerChangeDataDto) {
        // 自行输入时，检验设备代码的全局唯一性
        if (registerChangeDataDto.getEquCodeType().equals(EquCodeTypeEnum.INPUT.getCode()) && StringUtils.isNotEmpty(registerChangeDataDto.getEquCode())) {
            Boolean isUsed = this.checkEquCodeUniqueness(registerChangeDataDto.getEquCode(), record);
            if (isUsed) {
                throw new BadRequest("设备代码：" + registerChangeDataDto.getEquCode() + "在系统中已存在！");
            }
        }
    }


    private Boolean checkEquCodeUniqueness(String equCode, String record) {
        // 根据设备代码检查唯一性
        return idxBizJgRegisterInfoMapper.selectByEquCodeAndClaimStatus(equCode, "", record) > 0;
    }

    public void checkDesignChangeData(String record, EquipDesignChangeDataDto equipDesignChangeDataDto) {
    }
}
