package com.yeejoin.amos.boot.module.jg.biz.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yeejoin.amos.boot.module.jg.biz.service.IIdxBizJgInspectionDetectionInfoService;
import com.yeejoin.amos.boot.module.ymt.api.dto.IdxBizJgInspectionDetectionInfoDto;
import com.yeejoin.amos.boot.module.ymt.api.entity.IdxBizJgInspectionDetectionInfo;
import com.yeejoin.amos.boot.module.ymt.api.mapper.IdxBizJgInspectionDetectionInfoMapper;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.util.ArrayList;
import java.util.List;

/**
 * 安全追溯-检验检测信息表服务实现类
 *
 * @author system_generator
 * @date 2023-08-17
 */
@Service
public class IdxBizJgInspectionDetectionInfoServiceImpl extends BaseService<IdxBizJgInspectionDetectionInfoDto, IdxBizJgInspectionDetectionInfo, IdxBizJgInspectionDetectionInfoMapper> implements IIdxBizJgInspectionDetectionInfoService {

    public boolean saveOrUpdateData(IdxBizJgInspectionDetectionInfo inspectionDetectionInfo) {
        return this.saveOrUpdate(inspectionDetectionInfo);
    }

    //查询最新的记录
    public IdxBizJgInspectionDetectionInfo queryNewestDetailByRecord(String record) {
        IdxBizJgInspectionDetectionInfo result = new IdxBizJgInspectionDetectionInfo();
        QueryWrapper<IdxBizJgInspectionDetectionInfo> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().eq(IdxBizJgInspectionDetectionInfo::getRecord,record).orderByDesc(IdxBizJgInspectionDetectionInfo::getInspectDate);
        List<IdxBizJgInspectionDetectionInfo> inspectionDetectionInfoList = list(queryWrapper);
        if (!ValidationUtil.isEmpty(inspectionDetectionInfoList)) {
            BeanUtils.copyProperties(inspectionDetectionInfoList.get(0), result);
        }
        return result;
    }

    @Override
    public List<IdxBizJgInspectionDetectionInfo> checkInspectionInfo(List<String> records) {
        ArrayList<IdxBizJgInspectionDetectionInfo> result = new ArrayList<>();
        for (String record : records) {
            QueryWrapper<IdxBizJgInspectionDetectionInfo> queryWrapper = new QueryWrapper<>();
            queryWrapper.lambda().eq(IdxBizJgInspectionDetectionInfo::getRecord, record)
                    .orderByDesc(IdxBizJgInspectionDetectionInfo::getInspectDate);
            List<IdxBizJgInspectionDetectionInfo> list = list(queryWrapper);
            if (!ValidationUtil.isEmpty(list)){
                result.add(list.get(0));
            }
        }
        return result;
    }
}