package com.yeejoin.amos.boot.module.jg.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.google.common.collect.Lists;
import com.yeejoin.amos.boot.module.common.api.dao.ESEquipmentCategory;
import com.yeejoin.amos.boot.module.common.api.dto.ESEquipmentCategoryDto;
import com.yeejoin.amos.boot.module.jg.api.entity.SafetyProblemTracing;
import com.yeejoin.amos.boot.module.jg.api.enums.SafetyProblemStatusEnum;
import com.yeejoin.amos.boot.module.jg.api.enums.SafetyProblemTypeEnum;
import com.yeejoin.amos.boot.module.jg.api.mapper.CommonMapper;
import com.yeejoin.amos.boot.module.jg.api.mapper.SafetyProblemTracingMapper;
import com.yeejoin.amos.boot.module.ymt.api.entity.IdxBizJgOtherInfo;
import net.javacrumbs.shedlock.spring.annotation.SchedulerLock;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.component.emq.EmqKeeper;

import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
/**
 * 安全追溯问题生成服务实现类
 *
 * @author system_generator
 * @date 2024-05-21
 */
@Service
public class SafetyProblemTracingGenServiceImpl{
    final static Logger logger = LoggerFactory.getLogger(SafetyProblemTracingGenServiceImpl.class);

    @Autowired
    CommonMapper commonMapper;

    @Autowired
    IdxBizJgOtherInfoServiceImpl idxBizJgOtherInfoService;

    @Autowired
    ESEquipmentCategory esEquipmentCategory;

    @Autowired
    EmqKeeper emqKeeper;

    @Autowired
    private SafetyProblemTracingServiceImpl safetyProblemTracingService;

    @Scheduled(cron = "0 0 1 * * ?")
    @SchedulerLock(name = "executeSafetyProblemCheck", lockAtMostFor = "PT5H", lockAtLeastFor = "PT10M")
    public void executeSafetyProblemCheck() {
        executeMaintenanceCheck();
        executeInspectionCheck();
    }

    public void executeInspectionCheck() {
        logger.info("开始检验检测超期检查");
        // 查询当天检验超期的设备
        List<Map<String, Object>> outOfInspectionRecords = commonMapper.queryOutOfInspectionRecord();
        updateEquipAndSendMessage(outOfInspectionRecords, SafetyProblemTypeEnum.JYCQ);
        logger.info("检验检测超期检查结束");
    }

    public void executeMaintenanceCheck() {
        logger.info("开始维保超期检查");
        // 查询当天维保超期的设备
        List<Map<String, Object>> outOfMaintenanceRecords = commonMapper.queryOutOfMaintenanceRecord();
        updateEquipAndSendMessage(outOfMaintenanceRecords, SafetyProblemTypeEnum.WBCQ);
        logger.info("维保超期检查结束");
    }

    public void update3MaintenanceCheck() {
        logger.info("开始修正数据");
        List<String> oldAllRecords = idxBizJgOtherInfoService.getBaseMapper()
                .selectList(new LambdaQueryWrapper<IdxBizJgOtherInfo>()
                        .eq(IdxBizJgOtherInfo::getStatus, SafetyProblemStatusEnum.UNHANDLED.getCode()))
                .stream()
                .map(IdxBizJgOtherInfo::getRecord)
                .collect(Collectors.toList());
        logger.info("总的旧数据条数：{}",oldAllRecords.size());
        List<Map<String, Object>> outOfMaintenanceRecords = commonMapper.queryOutOfMaintenanceRecord();
        List<String> realRecordsMain = outOfMaintenanceRecords.stream().map(m -> m.get("RECORD").toString()).collect(Collectors.toList());
        List<Map<String, Object>> outOfInspectionRecords = commonMapper.queryOutOfInspectionRecord();
        List<String> realRecordsInsp = outOfInspectionRecords.stream().map(m -> m.get("RECORD").toString()).collect(Collectors.toList());
        realRecordsMain.addAll(realRecordsInsp);
        logger.info("正常数据条数：{}", realRecordsMain.size());
        List<String> errorRecord = oldAllRecords.stream().filter(item -> !realRecordsMain.contains(item)).collect(Collectors.toList());
        logger.info("异常数据条数---------------：{}",errorRecord.size());
        safetyProblemTracingService.lambdaUpdate()
                .set(SafetyProblemTracing::getProblemStatusCode, SafetyProblemStatusEnum.HANDLED.getCode())
                .set(SafetyProblemTracing::getProblemStatus, SafetyProblemStatusEnum.HANDLED.getName())
                .in(SafetyProblemTracing::getSourceId, errorRecord)
                .eq(SafetyProblemTracing::getProblemTypeCode, SafetyProblemTypeEnum.WBCQ.getCode())
                .eq(SafetyProblemTracing::getIsDelete,Boolean.FALSE)
                .update();
        idxBizJgOtherInfoService.lambdaUpdate().set(IdxBizJgOtherInfo::getStatus, null)
                .in(IdxBizJgOtherInfo::getRecord, errorRecord).update();
        Iterable<ESEquipmentCategoryDto> equipEsDtoIter = esEquipmentCategory.findAllById(errorRecord);
        for (ESEquipmentCategoryDto equipEsDto : equipEsDtoIter) {
            equipEsDto.setProblemStatus(null);
        }
        esEquipmentCategory.saveAll(equipEsDtoIter);
        logger.info("修改正数据条数：{}",errorRecord.size());
    }

    private void updateEquipAndSendMessage(List<Map<String, Object>> mapList, SafetyProblemTypeEnum safetyProblemTypeEnum)  {
        List<String> records = mapList.stream().map(m -> m.get("RECORD").toString()).collect(Collectors.toList());
        // 更新设备状态为未处理（异常）
        idxBizJgOtherInfoService.lambdaUpdate()
                .in(IdxBizJgOtherInfo::getRecord, records)
                .set(IdxBizJgOtherInfo::getStatus, SafetyProblemStatusEnum.UNHANDLED.getCode())
                .update();
        List<ESEquipmentCategoryDto> esEquipmentCategoryDto = Lists.newArrayList();
        for (ESEquipmentCategoryDto equipmentCategoryDto : esEquipmentCategory.findAllById(records)) {
            equipmentCategoryDto.setProblemStatus(SafetyProblemStatusEnum.UNHANDLED.getCode());
            esEquipmentCategoryDto.add(equipmentCategoryDto);
        }
        esEquipmentCategory.saveAll(esEquipmentCategoryDto);
//        JSONObject jsonObject = new JSONObject();
//        jsonObject.put(safetyProblemTypeEnum.getMsgKey(), mapList);
        JSONArray jsonArray = JSON.parseArray(JSON.toJSONString(mapList));
        try {
            emqKeeper.getMqttClient().publish(safetyProblemTypeEnum.getTopic(), jsonArray.toString().getBytes(StandardCharsets.UTF_8), 2, false);
        } catch (MqttException e) {
            logger.error("发送安全追溯问题设备信息消息失败---->{}", e.getMessage());
            throw new RuntimeException(e);
        }
    }
}