package com.yeejoin.amos.boot.module.jyjc.biz.job;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.yeejoin.amos.boot.module.jyjc.biz.service.impl.JyjcOpeningApplicationServiceImpl;
import lombok.extern.slf4j.Slf4j;
import net.javacrumbs.shedlock.spring.annotation.SchedulerLock;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author Administrator
 */
@EnableScheduling
@Component
@Slf4j
public class OpenApplicationTimingDiscardJob {


    private JyjcOpeningApplicationServiceImpl jyjcOpeningApplicationServiceImpl;

    public OpenApplicationTimingDiscardJob(JyjcOpeningApplicationServiceImpl jyjcOpeningApplicationServiceImpl) {
        this.jyjcOpeningApplicationServiceImpl = jyjcOpeningApplicationServiceImpl;
    }

    /**
     * 自动作废
     *
     * @author yangyang
     * @date 2023/12/22 16:13
     */
    @SchedulerLock(name = "timingDiscard", lockAtMostFor = "PT1H")
    @Scheduled(cron = "0 0 0 * * ?")
    public void timingDiscard() {

        List<Long> longs = jyjcOpeningApplicationServiceImpl.selectOverdueData();

        if (CollectionUtils.isNotEmpty(longs)) {
            for (Long aLong : longs) {
                String remark = "许可到期，系统自动作废";
                jyjcOpeningApplicationServiceImpl.doDiscard(aLong, remark);

            }
        }
    }
}
