package com.yeejoin.amos.patrol.dao.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import lombok.experimental.Accessors;
import org.springframework.data.annotation.Id;
import org.springframework.data.elasticsearch.annotations.DateFormat;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;

import java.util.Date;
import java.util.List;

/**
 * @Author cpp
 * @Description
 * @Date 2023/6/5
 */
@Data
@Accessors(chain = true)
@Document(indexName = "web_app_plan_task_list", shards = 6, replicas = 2)
public class ESPlanTaskListDto {


    @Id
    private String id;

    @Field(type = FieldType.Text)
    private String planTaskId;


    @Field(type = FieldType.Text)
    private String orgCode;

    @Field(type = FieldType.Text)
    private String planId;

    @Field(type = FieldType.Text)
    private String useCode;

    @Field(type = FieldType.Text)
    private String taskName;

    @Field(type = FieldType.Text)
    private String type;

    @Field(type = FieldType.Keyword)
    private String beginTime;

    @Field(type = FieldType.Keyword)
    private String endTime;

    @Field(type = FieldType.Keyword)
    private String checkDate;

    @Field(type = FieldType.Text)
    private String finshNum;

    @Field(type = FieldType.Text)
    private String taskPlanNum;

    @Field(type = FieldType.Text)
    private String finishStatus;

    @Field(type = FieldType.Text)
    private String batchNo;

    @Field(type = FieldType.Text)
    private String executiveName;

    @Field(type = FieldType.Text)
    private String userName;

    @Field(type = FieldType.Text)
    private String userDept;



    @Field(type = FieldType.Text)
    private String unplan;

    @Field(type = FieldType.Text)
    private String userId;

    @Field(type = FieldType.Text)
    private String unqualified;

    @Field(type = FieldType.Text)
    private String inOrder;


    @Field(type = FieldType.Text)
    private String omission;

    @Field(type = FieldType.Object)
    private List points;


}
