package com.yeejoin.amos.boot.module.ymt.api.dto;

import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 工程装置-施工信息表
 *
 * @author system_generator
 * @date 2024-12-12
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="IdxBizJgProjectConstructionDto", description="工程装置-施工信息表")
public class IdxBizJgProjectConstructionDto  extends BaseDto {

   private static final long serialVersionUID = 1L;

    private String record;

    private Date recDate;

    private String recUserId;

    private String instanceId;

    private String status;

    @ApiModelProperty(value = "施工类型")
    private String constructionType;

    @ApiModelProperty(value = "施工单位统一社会信用代码")
    private String uscUnitCreditCode;

    @ApiModelProperty(value = "施工单位名称")
    private String uscUnitName;

    @ApiModelProperty(value = "施工时间")
    private Date uscDate;

    @ApiModelProperty(value = "工程装置唯一标识")
    private String sequenceCode;

    @ApiModelProperty(value = "告知业务id")
    private String noticeId;

    @ApiModelProperty(value = "告知书编号")
    private String informCode;

    @ApiModelProperty(value = "告知书路径")
    private String informFilePath;

    @ApiModelProperty(value = "施工负责人ID")
    private String constructionLeaderId;

    @ApiModelProperty(value = "施工负责人")
    private String constructionLeaderName;

    @ApiModelProperty(value = "施工负责人手机")
    private String constructionLeaderPhone;

    @ApiModelProperty(value = "施工委托书图片")
    private String proxyStatementAttachment;

    @ApiModelProperty(value = "施工合同照片")
    private String constructionContractAttachment;

    @ApiModelProperty(value = "其他附件")
    private String constructionOtherAccessories;

    @ApiModelProperty(value = "关联设备ids")
    private String equipRecords;

}
