package com.yeejoin.amos.boot.module.common.biz.controller;

import com.yeejoin.amos.boot.module.common.api.dto.FailureAuditDto;
import com.yeejoin.amos.boot.module.common.api.entity.FailureAudit;
import com.yeejoin.amos.boot.module.common.api.entity.FailureVerify;
import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import java.util.List;
import com.yeejoin.amos.boot.module.common.biz.service.impl.FailureVerifyServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.common.api.dto.FailureVerifyDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 故障报修验收记录
 *
 * @author system_generator
 * @date 2021-08-18
 */
@RestController
@Api(tags = "故障报修验收记录Api")
@RequestMapping(value = "/common/failure-verify")
public class FailureVerifyController extends BaseController {

    @Autowired
    FailureVerifyServiceImpl failureVerifyServiceImpl;

    /**
     * 新增故障报修验收记录
     *
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增", notes = "新增")
	public ResponseModel<Object>  save(@RequestBody FailureVerifyDto model)  {
		try {
			return ResponseHelper.buildResponse(failureVerifyServiceImpl.savemodel(model,getSelectedOrgInfo()));
		} catch (Exception e) {
			e.printStackTrace();
			return ResponseHelper.buildResponse(false);
		}
	}


	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新故障报修验收记录", notes = "根据sequenceNbr更新故障报修验收记录")
	public ResponseModel<FailureVerifyDto> updateBySequenceNbrFailureVerify(@RequestBody FailureVerifyDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(failureVerifyServiceImpl.updateWithModel(model));
	}



/*
    */
/**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     *//*

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个故障报修验收记录",  notes = "根据sequenceNbr查询单个故障报修验收记录")
	public ResponseModel<FailureVerifyDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(failureVerifyServiceImpl.queryBySeq(sequenceNbr));
	}
*/

/*	*//**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     *//*
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "故障报修验收记录分页查询",  notes = "故障报修验收记录分页查询")
	public ResponseModel<Page<FailureVerifyDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size) {
	    Page<FailureVerifyDto> page = new Page<FailureVerifyDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(failureVerifyServiceImpl.queryForFailureVerifyPage(page));
	}*/

/*
	*/
/**
	 * 列表全部数据查询
     *
	 * @return
	 *//*

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "故障报修验收记录列表全部数据查询",   notes = "故障报修验收记录列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<FailureVerifyDto>> selectForList() {
	    return ResponseHelper.buildResponse(failureVerifyServiceImpl.queryForFailureVerifyList());
	}
*/


	/**
	 * 审核列表记录查询
	 *根据关联主表faultId查询
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "审核列表记录查询",   notes = "审核列表记录查询")
	@GetMapping(value = "/list/{faultId}")
	public ResponseModel<List<FailureVerify>> findByFaultIDFotList(@PathVariable long faultId) {
		return ResponseHelper.buildResponse(failureVerifyServiceImpl.findByfaultId(faultId));
	}

}
