package com.yeejoin.amos.boot.biz.common.enums;

/**
 * 规则请求枚举
 * @author xl
 *
 */
public enum RuleTypeEnum {
	// 防火监督
	计划提交("计划提交", "addPlan","auditPage"),
	计划审核("计划审核", "planAudit", "auditPage"),
	计划审核完成("计划审核完成", "planAuditAll", "formulatePage"),
	计划生成("计划生成", "addPlanTask", null),
	计划完成("计划完成", "planCompleted", null),

	// 隐患
	隐患第一次提交("隐患提交", "addLatentDanger", null),
	隐患审核("隐患审核", "dangerAudit", null);

	/**
	 * 名称，描述
	 */
	private String name;
	/**
	 * 编码
	 */
	private String code;
	/**
	 * 跳转地址
	 */
	private String url;

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getUrl() {
		return url;
	}

	public void setUrl(String url) {
		this.url = url;
	}

	RuleTypeEnum(String name, String code, String url) {
		this.name = name;
		this.code = code;
		this.url = url;
	}

	public static RuleTypeEnum getEnumByCode(String field){
		for (RuleTypeEnum constants : values()) {
			if (constants.getCode().equals(field)) {
				return constants;
			}
		}
		return null;
	}
}
