package com.yeejoin.equipmanage.controller;


import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.utils.RedisKey;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.equipmanage.config.PersonIdentify;
import com.yeejoin.equipmanage.service.DutyDetailsService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.*;


/**
 * 获取用户信息
 *
 */
@RestController
@RequestMapping(value = "/org/user")
@Api(tags = "用户信息api")
public class OrgUserController {
    @Autowired
    DutyDetailsService dutyDetailsService;
    @Autowired
    RedisUtils redisUtils;

    /**
     * 今日值班运维人员列表清单--分页
     *
     * @return ResponseModel
     */
    @PersonIdentify
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "duty-person/page-list")
    @ApiOperation(httpMethod = "GET", value = "今日值班运维人员列表清单", notes = "今日值班运维人员列表清单")
    public ResponseModel<IPage<Map<String, Object>>> dutyPersonPageList(
            @ApiParam(value = "当前页", required = true) @RequestParam(value = "current") int current,
            @ApiParam(value = "页面大小", required = true) @RequestParam(value = "size") int size) {
        ReginParams reginParams = JSONObject.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(), ReginParams.class);
        String bizOrgCode = reginParams.getPersonIdentity().getBizOrgCode();
        return ResponseHelper.buildResponse(dutyDetailsService.dutyPersonPageList(current, size, bizOrgCode));
    }

}