package com.yeejoin.amos.boot.module.demo.biz.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.biz.common.utils.NameUtils;
import com.yeejoin.amos.boot.module.demo.api.entity.Demo;
import com.yeejoin.amos.boot.module.demo.api.service.IDemoService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;

import javax.servlet.http.HttpServletRequest;
import java.util.Arrays;


/**
* 
*
* @author tb
* @date 2021-05-31
*/
@RestController
@Api(tags = "Api")
@RequestMapping(value = "/demo")
@Slf4j
public class DemoController extends BaseController {

    @Autowired
    IDemoService iDemoService;

    /**
    * 新增
    * @return
    */
    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/save")
    @ApiOperation(httpMethod = "POST", value = "新增", notes = "新增")
    public boolean saveDemo(HttpServletRequest request, @RequestBody Demo demo){
        return iDemoService.save(demo);
    }

    /**
    * 根据id删除
    * @param id
    * @return
    */
    @RequestMapping(value = "/{id}", method = RequestMethod.DELETE)
    @ApiOperation(httpMethod = "DELETE", value = "根据id删除", notes = "根据id删除")
    public boolean deleteById(HttpServletRequest request, @PathVariable Long id){
        return iDemoService.removeById(id);
    }




    /**
    * 修改
    * @return
    */
    @RequestMapping(value = "/updateById", method = RequestMethod.PUT)
    @ApiOperation(httpMethod = "PUT", value = "修改", notes = "修改")
    public boolean updateByIdDemo(HttpServletRequest request, @RequestBody Demo demo){
        return iDemoService.updateById(demo);
    }



    /**
    * 根据id查询
    * @param id
    * @return
    */
    @RequestMapping(value = "/{id}", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "根据id查询", notes = "根据id查询")
    public Demo selectById(HttpServletRequest request, @PathVariable Long id){
        return iDemoService.getById(id);
    }



    /**
    * 列表分页查询
    * @return
    */
    @RequestMapping(value = "/list", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "列表分页查询", notes = "列表分页查询")
    public IPage<Demo> listPage(String pageNum,String pageSize, Demo demo){

        Page<Demo> pageBean;
        QueryWrapper<Demo> demoQueryWrapper = new QueryWrapper<>();
        Class<? extends Demo> aClass = demo.getClass();
        Arrays.stream(aClass.getDeclaredFields()).forEach(field -> {
            try {
                ReflectionUtils.makeAccessible(field);
                Object o = field.get(demo);
                if (o != null) {
                    Class<?> type = field.getType();
                    String name = NameUtils.camel2Underline(field.getName());
                    if (type.equals(Integer.class)) {
                        Integer fileValue = (Integer) field.get(demo);
                        demoQueryWrapper.eq(name, fileValue);
                    } else if (type.equals(Long.class)) {
                        Long fileValue = (Long) field.get(demo);
                        demoQueryWrapper.eq(name, fileValue);
                    } else if (type.equals(String.class)) {
                        String fileValue = (String) field.get(demo);
                        demoQueryWrapper.eq(name, fileValue);
                    } else {
                        String fileValue = (String) field.get(demo);
                        demoQueryWrapper.eq(name, fileValue);
                    }
                }
            } catch (Exception e) {
            }
        });
        IPage<Demo> page;
        if (StringUtils.isBlank(pageNum) || StringUtils.isBlank(pageSize)) {
            pageBean = new Page<>(0, Long.MAX_VALUE);
        } else {
            pageBean = new Page<>(Integer.parseInt(pageNum), Integer.parseInt(pageSize));
        }
        page = iDemoService.page(pageBean, demoQueryWrapper);
            return page;
        }
    }


