package com.yeejoin.equipmanage.controller;

import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.equipmanage.common.entity.FireFightingSystemEntity;
import com.yeejoin.equipmanage.common.entity.dto.FireFightingSystemGroupModalDto;
import com.yeejoin.equipmanage.common.utils.CommonResponseUtil;
import com.yeejoin.equipmanage.service.FireFightingSystemGroupService;
import com.yeejoin.equipmanage.service.IFireFightingSystemService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@Slf4j
@RestController
@Api(tags = "消防系统分组")
@RequestMapping(value = "/fire-fighting-system-group")
public class FireFightingSystemGroupController extends BaseController {

    @Autowired
    private FireFightingSystemGroupService fireFightingSystemGroupService;

    @ApiOperation(value = "消防系统列表查询（未绑定分组的系统）", notes = "下拉使用")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/systems")
    public ResponseModel systems(@RequestParam(value = "bizOrgCode", required = false) String bizOrgCode) {
        if (StringUtils.isEmpty(bizOrgCode)) {
            ReginParams reginParams = getSelectedOrgInfo();
            ReginParams.PersonIdentity personIdentity = reginParams.getPersonIdentity();
            if (!ValidationUtil.isEmpty(personIdentity)) {
                bizOrgCode = personIdentity.getBizOrgCode();
            }
        }
        return CommonResponseUtil.success(fireFightingSystemGroupService.selectUnboundSystems(bizOrgCode));
    }

    @RequestMapping(value = "/save-or-update", method = {RequestMethod.PUT, RequestMethod.POST})
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "PUT", value = "添加/更新分组", notes = "添加/更新分组")
    public ResponseModel save(@RequestBody FireFightingSystemGroupModalDto dto) {
        if (!(Objects.nonNull(dto.getGroupName()) && Objects.nonNull(dto.getDisplayType()) && Objects.nonNull(dto.getSystems()))) {
            return CommonResponseUtil.failure("非法参数");
        }
        ReginParams reginParams = getSelectedOrgInfo();
        dto.setBizOrgCode(reginParams.getPersonIdentity().getCompanyBizOrgCode());
        dto.setBizOrgName(reginParams.getPersonIdentity().getCompanyName());
        return CommonResponseUtil.success(fireFightingSystemGroupService.saveOrUpdate(dto));
    }

    @PutMapping(value = "/update-group-sort")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "PUT", value = "更新分组展示顺序", notes = "更新分组展示顺序")
    public ResponseModel updateGroupSort(@RequestParam("groupIds") String groupIds) {
        if (Objects.isNull(groupIds) || groupIds.isEmpty()) {
            return CommonResponseUtil.failure("非法参数");
        }
        List<Long> ids = Arrays.stream(groupIds.split(",")).map(Long::valueOf).mapToLong(Long::longValue).boxed().collect(Collectors.toList());
        fireFightingSystemGroupService.updateGroupSort(ids);
        return CommonResponseUtil.success();
    }

    @PostMapping(value = "/update-system-sort/{groupId}")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "更新系统展示顺序", notes = "更新系统展示顺序")
    public ResponseModel updateSystemSort(@PathVariable Long groupId, @RequestBody List<Long> systemIds) {
        if (Objects.isNull(systemIds) || systemIds.isEmpty()) {
            return CommonResponseUtil.failure("非法参数");
        }
        fireFightingSystemGroupService.updateSystemSort(groupId, systemIds);
        return CommonResponseUtil.success();
    }

    @GetMapping(value = "/list")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "查询分组列表", notes = "查询分组列表")
    public ResponseModel list(@RequestParam(required = false) String bizOrgCode) {
        if (StringUtils.isEmpty(bizOrgCode)) {
            ReginParams reginParams = getSelectedOrgInfo();
            bizOrgCode = reginParams.getPersonIdentity().getCompanyBizOrgCode();
        }
        return CommonResponseUtil.success(fireFightingSystemGroupService.listGroup(bizOrgCode));
    }

    @DeleteMapping(value = "/{id}")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "DELETE", value = "删除分组", notes = "删除分组")
    public ResponseModel deteleGroup(@PathVariable("id") Long id) {
        fireFightingSystemGroupService.deleteGroup(id);
        return CommonResponseUtil.success();
    }
}
