package com.yeejoin.equipmanage.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.equipmanage.common.entity.BaseBill;
import com.yeejoin.equipmanage.common.entity.Repair;
import com.yeejoin.equipmanage.common.entity.RepairDetail;
import com.yeejoin.equipmanage.common.utils.DateUtils;
import com.yeejoin.equipmanage.common.utils.NameUtils;
import com.yeejoin.equipmanage.common.vo.StockDataVO;
import com.yeejoin.equipmanage.service.IRepairService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 *
 *
 * @author wujiang
 * @date 2020-07-15
 */
@RestController
@Api(tags = "Api")
@RequestMapping(value = "/repair", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class RepairController extends AbstractBaseController {

	@Autowired
	IRepairService iRepairService;

	/**
	 * 新增
	 *
	 * @return
	 */
	@RequestMapping(value = "/save", method = RequestMethod.POST)
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "POST", value = "新增", notes = "新增")
	public boolean saveRepair(HttpServletRequest request, @RequestBody Repair repair) {
		return iRepairService.save(repair);
	}

	/**
	 * 根据id删除
	 *
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/{id}", method = RequestMethod.DELETE)
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "DELETE", value = "根据id删除", notes = "根据id删除")
	public boolean deleteById(HttpServletRequest request, @PathVariable Long id) {
		return iRepairService.removeById(id);
	}

	/**
	 * 修改
	 *
	 * @return
	 */
	@RequestMapping(value = "/updateById", method = RequestMethod.PUT)
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "PUT", value = "修改", notes = "修改")
	public boolean updateByIdRepair(HttpServletRequest request, @RequestBody Repair repair) {
		return iRepairService.updateById(repair);
	}

	/**
	 * 根据id查询
	 *
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/{id}", method = RequestMethod.GET)
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET", value = "根据id查询", notes = "根据id查询")
	public Repair selectById(HttpServletRequest request, @PathVariable Long id) {
		return iRepairService.getById(id);
	}

	/**
	 * 列表分页查询
	 *
	 * @return
	 */
	@RequestMapping(value = "/list", method = RequestMethod.GET)
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET", value = "列表分页查询", notes = "列表分页查询")
	public IPage<Repair> listPage(String pageNum, String pageSize, Repair repair) {

		Page<Repair> pageBean;
		QueryWrapper<Repair> repairQueryWrapper = new QueryWrapper<>();
		Class<? extends Repair> aClass = repair.getClass();
		Arrays.stream(aClass.getDeclaredFields()).forEach(field -> {
			try {
				ReflectionUtils.makeAccessible(field);
				Object o = field.get(repair);
				if (o != null) {
					Class<?> type = field.getType();
					String name = NameUtils.camel2Underline(field.getName());
					if (type.equals(Integer.class)) {
						Integer fileValue = (Integer) field.get(repair);
						repairQueryWrapper.eq(name, fileValue);
					} else if (type.equals(Long.class)) {
						Long fileValue = (Long) field.get(repair);
						repairQueryWrapper.eq(name, fileValue);
					} else if (type.equals(String.class)) {
						String fileValue = (String) field.get(repair);
						repairQueryWrapper.eq(name, fileValue);
					} else {
						String fileValue = (String) field.get(repair);
						repairQueryWrapper.eq(name, fileValue);
					}
				}
			} catch (Exception e) {
			}
		});
		IPage<Repair> page;
		if (StringUtils.isBlank(pageNum) || StringUtils.isBlank(pageSize)) {
			pageBean = new Page<>(0, Long.MAX_VALUE);
		} else {
			pageBean = new Page<>(Integer.parseInt(pageNum), Integer.parseInt(pageSize));
		}
		page = iRepairService.page(pageBean, repairQueryWrapper);
		return page;
	}

	/**
	 * 执行维修
	 *
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/exec/{type}", method = RequestMethod.POST)
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "POST", value = "维修", notes = "根据id查询")
	public BaseBill exec(@RequestBody List<RepairDetail> list, @PathVariable String type) throws Exception {
		Repair repair = iRepairService.exec(list, type, getUserInfo());
		BaseBill baseBill = new BaseBill(repair.getBillCode(), getUserInfo().getRealName(), DateUtils.getNowStrLong(),
				repair.getId(), new ArrayList<StockDataVO>());
		return baseBill;
	}

	/**
	 * 执行维修完成
	 *
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/complete/{type}", method = RequestMethod.POST)
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "POST", value = "维修", notes = "根据id查询")
	public BaseBill complete(@RequestBody List<RepairDetail> list, @PathVariable String type) {
		Repair repair = iRepairService.complete(list, type);
		BaseBill baseBill = new BaseBill(repair.getBillCode(), getUserInfo().getRealName(), DateUtils.getNowStrLong(),
				repair.getId(), new ArrayList<StockDataVO>());
		return baseBill;
	}
}
