package com.yeejoin.amos.boot.module.jcs.biz.kafka;

import com.yeejoin.amos.boot.module.jcs.api.service.ICcsToStationUserInfo;
import lombok.extern.slf4j.Slf4j;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.kafka.support.Acknowledgment;
import org.springframework.stereotype.Service;

import java.util.Optional;


/**
 * kafka 消费服务
 *
 * @author litw
 * @create 2022/11/1 10:06
 **/
@Slf4j
@Service
public class KafkaConsumerService {

    @Autowired
    ICcsToStationUserInfo ccsToStationUserInfo;

    /**
     * 转发苏州，绍兴换流站Kafka数据对emq
     *
     * @param record record
     * @param ack    ack
     */
    @KafkaListener(id = "kafkaRoma", groupId = "kafkaRoma", topics = "amos.privilege.v1.STATE_GRID.AMOS_ADMIN.login", containerFactory = "kafkaRomaContainerFactory")
    public void kafkaListener(ConsumerRecord<?, String> record, Acknowledgment ack) {
        try {
            Optional<?> messages = Optional.ofNullable(record.value());
            if (messages.isPresent()) {
                log.info("收到kafka消息发送登录信息>>{}", record.value());
                ccsToStationUserInfo.sendUserInfoToStation(record.value());
            }
        } catch (Exception e) {
            log.error("消费kafka消息发送登录信息失败，{}", e.getMessage());
        } finally {
            ack.acknowledge();
        }
    }

}


