package com.yeejoin.amos.boot.module.common.api.dto;

import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;
/**
* 岗位信息
*
* @author tb
* @date 2021-06-07
*/
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="FirefightersPostDto", description="岗位信息")
public class FirefightersPostDto extends BaseDto {
    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "人员id")
    private Long firefightersId;

    @ApiModelProperty(value = "员工层级")
    private String employeeHierarchy;

    @ApiModelProperty(value = "行政职务")
    private String administrativePosition;

    @ApiModelProperty(value = "岗位资质")
    private String postQualification;

    @ApiModelProperty(value = "消防救援人员类别")
    private String category;

    @ApiModelProperty(value = "消防救援人员状态")
    private String state;

    @ApiModelProperty(value = "消防救援衔级别代码")
    private String level;

    @ApiModelProperty(value = "资质证书")
    private String qualificationCertificate;

    @ApiModelProperty(value = "消防专家领域")
    private String areasExpertise;

    @ApiModelProperty(value = "是否专家_判断标识")
    private String isnoExpert;

    @ApiModelProperty(value = "更新时间")
    private Date updateTime;

    @ApiModelProperty(value = "操作人名称")
    private String recUserName;

}
