package com.yeejoin.equipmanage.common.enums;

public enum EquipStatusEnum {

	REPERTORY(1L, "库存"), REPAIR(3L, "维修"), SCRAP(7L, "报废"),
	ONCAR(10L, "车载"), LOSS(11L, "损耗"), LOAD(12L, "配装"),
	UNLOAD(13L, "退装");
	private Long code;

	private String describe;

	private EquipStatusEnum(Long code, String describe) {
		this.code = code;
		this.describe = describe;
	}

	public Long getCode() {
		return code;
	}

	public void setCode(Long code) {
		this.code = code;
	}

	public String getDescribe() {
		return describe;
	}

	public void setDescribe(String describe) {
		this.describe = describe;
	}

	public static EquipStatusEnum getEnum(Long code) {
		EquipStatusEnum equipStatusEnum = null;
		for (EquipStatusEnum type : EquipStatusEnum.values()) {
			if (type.getCode().longValue() == code.longValue()) {
				equipStatusEnum = type;
				break;
			}
		}

		return equipStatusEnum;
	}

//	public static EquipStatusEnum getEnum(String describe) {
//		EquipStatusEnum equipStatusEnum = null;
//		for (EquipStatusEnum type : EquipStatusEnum.values()) {
//			if (type.getDescribe().equals(describe)) {
//				equipStatusEnum = type;
//				break;
//			}
//		}
//
//		return equipStatusEnum;
//	}
}
