package com.yeejoin.amos.boot.module.ccs.biz.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.boot.biz.common.utils.DateUtils;
import com.yeejoin.amos.boot.module.ccs.api.dto.FireEquipmentDto;
import com.yeejoin.amos.boot.module.ccs.api.entity.FireEquipment;
import com.yeejoin.amos.boot.module.ccs.api.mapper.FireEquipmentSignalLogMapper;
import com.yeejoin.amos.boot.module.ccs.api.mapper.FireEquipmentSignalMapper;
import com.yeejoin.amos.boot.module.ccs.api.mapper.FireEquipmentMapper;
import com.yeejoin.amos.boot.module.ccs.api.mapper.FireStationInfoMapper;
import com.yeejoin.amos.boot.module.ccs.api.service.IFireEquipmentService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 消防设备资产服务实现类
 *
 * @author system_generator
 * @date 2021-11-09
 */
@Service
public class FireEquipmentServiceImpl extends BaseService<FireEquipmentDto, FireEquipment, FireEquipmentMapper> implements IFireEquipmentService {

    @Autowired
    FireEquipmentSignalLogMapper fireEquipmentSignalLogMapper;
    @Autowired
    FireStationInfoMapper stationInfoMapper;
    @Autowired
    FireEquipmentSignalMapper fireEquipmentSignalMapper;

    @Override
    public Map<String, Object> selectForMonitorCount(String stationCode) throws ParseException {
        LambdaQueryWrapper<FireEquipment> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(FireEquipment::getIsIot, true);
        wrapper.eq(StringUtils.isNotBlank(stationCode), FireEquipment::getStationCode, stationCode);
        int totalIotEquipment = this.count(wrapper);
        List<FireEquipmentDto> logs = fireEquipmentSignalLogMapper.distinctByEquipmentId(stationCode, DateUtils.dateFormat(new Date(), DateUtils.DATE_PATTERN));
        Map<String, Object> result = new HashMap<>();
        result.put("totalIotEquipment", totalIotEquipment);
        result.put("todayAlarmEquipment", logs.size());
        return result;
    }

    @Override
    public List<Map<String, Object>> stationEquipmentInfo(String stationCode, String stationName) {
        return stationInfoMapper.queryStationEquipInfo(stationCode,stationName);
    }

    @Override
    public List<Map<String, Object>> faultEquipTopCount(Long top) {
        return fireEquipmentSignalMapper.faultEquipTopCount(top, new Date());
    }
}