package com.yeejoin.equipmanage.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yeejoin.equipmanage.common.dto.MaintenanceResourceDto;
import com.yeejoin.equipmanage.common.entity.MaintenanceResource;
import com.yeejoin.equipmanage.common.entity.MaintenanceResourceData;
import com.yeejoin.equipmanage.common.vo.MaintenanceResourceDataVo;
import com.yeejoin.equipmanage.common.vo.MaintenanceResourceVo;

import java.util.List;

/**
 * 维保设施资源树Service接口
 *
 * @author gaojianqiang
 * @date 2021-07-16
 */
public interface IMaintenanceResourceService extends IService<MaintenanceResource> {
    /**
     * 查询维保设施资源树
     *
     * @param id 维保设施资源树ID
     * @return 维保设施资源树
     */
    public MaintenanceResource selectMaintenanceResourceById(Long id);

    /**
     * 查询维保设施资源树列表
     *
     * @param maintenanceResource 维保设施资源树
     * @return 维保设施资源树集合
     */
    public List<MaintenanceResource> selectMaintenanceResourceList(MaintenanceResource maintenanceResource);

    /**
     * 新增维保设施资源树
     *
     * @param maintenanceResource 维保设施资源树
     * @return 结果
     */
    public int insertMaintenanceResource(MaintenanceResource maintenanceResource);

    /**
     * 修改维保设施资源树
     *
     * @param maintenanceResource 维保设施资源树
     * @return 结果
     */
    public int updateMaintenanceResource(MaintenanceResource maintenanceResource);

    /**
     * 批量删除维保设施资源树
     *
     * @param ids 需要删除的维保设施资源树ID
     * @return 结果
     */
    public int deleteMaintenanceResourceByIds(Long[] ids);

    /**
     * 删除维保设施资源树信息
     *
     * @param id 维保设施资源树ID
     * @return 结果
     */
    public int deleteMaintenanceResourceById(Long id);

    List<MaintenanceResourceDto> getMaintenanceResourceTree(String appKey, String product, String token);

    List<MaintenanceResourceDto> selectAll();

    List<MaintenanceResourceDto> combineTree(String appKey, String product, String token);

    List<MaintenanceResourceData> combineData(String appKey, String product, String token);

    IPage<MaintenanceResourceDataVo> combineDataPage(Page page, Long fireFightSysId, Long fireFacilityId, String fireFacilityName, String classifyId, List<Long> buildingId, String appKey, String product, String token);

    List<MaintenanceResourceDto> selectCompanyList(String appKey, String product, String token);

    List<MaintenanceResourceDto> findTreeById(Long id);

    List<MaintenanceResourceDto> selectOwnerUnitList(Long id, Integer type);

    IPage<MaintenanceResourceVo> getFireFightSysPage(Page page, Long maintenanceCompanyId, Long ownerUnitId, Long fireFightSysId, Integer type);

    Boolean updateBatch(List<MaintenanceResource> resourceList);
}
