package com.yeejoin.amos.boot.module.common.api.converter;

import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.CellData;
import com.alibaba.excel.metadata.GlobalConfiguration;
import com.alibaba.excel.metadata.property.ExcelContentProperty;
import org.springframework.stereotype.Component;

import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * 通用的自定义字段转换器
 * 用于处理Excel导入导出时的字段转换逻辑
 */
@Component
public class CommonCustomConverter {

    /**
     * 年月日格式转换器
     */
    public static class Y_M_D_DateConverter implements Converter<Date> {

        @Override
        public Class supportJavaTypeKey() {
            return null;
        }

        @Override
        public CellDataTypeEnum supportExcelTypeKey() {
            return null;
        }

        @Override
        public Date convertToJavaData(CellData cellData, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) throws Exception {
            return null;
        }

        @Override
        public CellData convertToExcelData(Date value, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) throws Exception {
            if (value == null) {
                return new CellData("");
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy年MM月dd日");
            return new CellData(sdf.format(value));
        }
    }

}
