package com.yeejoin.amos.boot.module.cylinder.flc.api.dto;
import io.swagger.annotations.ApiModel;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "CylinderUnitVideoDto", description = "气瓶企业视频信息")
public class CylinderUnitVideoDto extends BaseDto {
  /**
   *
   */
  private static final long serialVersionUID = 1L;
  /**
   *获取token地址
   */
  private String tokenUrl;
  /**
   *获取播放地址
   */
  private String url;
  /**
   *视频标题
   */
  private String title;
  /**
   *appkey
   */
  private String appKey;
  /**
   *appsecret
   */
  private String appSecret;
  /**
   *设备序列号
   */
  private String deviceSerial;
  /**
   *流播放协议，1-ezopen、2-hls、3-rtmp、4-flv，默认为1
   */
  private String protocol;
  /**
   * 通道号
   */
  private String channelNo;
  /**
   * 过期时长，单位秒；针对hls/rtmp/flv设置有效期，相对时间；30秒-720天
   */
  private Long expireTime;
  /**
   * 单位ID
   */
  private String unitSeq;
}
