package com.yeejoin.amos.boot.module.jg.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * @author Administrator
 */
@Data
@ApiModel("检索条件")
public class ReportAnalysisSearchDTO {

    @ApiModelProperty("开始日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    Date beginDate;

    @ApiModelProperty("结束日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    Date endDate;

    @ApiModelProperty("业务类型")
    String bizType;

    @ApiModelProperty("接收机构")
    String receiveOrgCode;

    @ApiModelProperty("设备种类code")
    String equList;

    @ApiModelProperty("设备类别code")
    String equCategory;

    @ApiModelProperty("设备品种code")
    String equDefine;

    @ApiModelProperty("排序逗号分开，逗号前字段，逗号后升序或者降序")
    String sort;

    public String getSortField(){
        return StringUtils.isNotEmpty(sort) ? sort.contains(",") ? sort.split(",")[0] : "" : "";
    }

    public String getSortOrder(){
        if(StringUtils.isNotEmpty(sort) && sort.contains(",") && "ascend".equals(sort.split(",")[1])){
            return "asc";
        }
        return "desc";
    }



}
