package com.yeejoin.amos.api.openapi.controller;

import com.yeejoin.amos.api.openapi.dto.InspectMockAppData;
import com.yeejoin.amos.api.openapi.face.dto.JyjcInspectionResultDataModel;
import com.yeejoin.amos.api.openapi.face.dto.PipelineInspectionResultDto;
import com.yeejoin.amos.api.openapi.feign.JyjcServiceFeignClient;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;

/**
 * 特种设备监管controller
 *
 * @author Administrator
 */
@RestController
@Api(tags = "检验检测Api")
@RequestMapping(value = "/inspection")
public class JyjcController {

    @Autowired
    JyjcServiceFeignClient jyjcServiceFeignClient;

    /**
     * 设备定义列表数据查询
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @PostMapping(value = "/result-submit")
    @ApiOperation(httpMethod = "POST", value = "非压力管道-检验检测结果回传", notes = "非压力管道-检验检测结果回传")
    public ResponseModel<List<JyjcInspectionResultDataModel>> resultSubmit(@RequestBody List<JyjcInspectionResultDataModel> resultDataModels) {
        return jyjcServiceFeignClient.saveResultDataBatch(resultDataModels);
    }

    /**
     * 设备定义列表数据查询
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @PostMapping(value = "/pipeline/result-submit")
    @ApiOperation(httpMethod = "POST", value = "压力管道-检验检测结果回传", notes = "压力管道-检验检测结果回传")
    public ResponseModel<List<PipelineInspectionResultDto>> pipelineResultSubmit(@RequestBody List<PipelineInspectionResultDto> resultDataModels) {
        return jyjcServiceFeignClient.savePipelineResultDataBatch(resultDataModels);
    }

    /**
     * 设备定义列表数据查询
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @PutMapping(value = "/inspect-app/test-push")
    @ApiOperation(httpMethod = "PUT", value = "报检对接联调测试数据生成测试接口", notes = "报检对接联调测试数据生成测试接口,模拟用户报检及审批通过后推送报检信息")
    public ResponseModel<Boolean> inspectAppTestPush(@RequestBody InspectMockAppData inspectMockAppData) {
        return jyjcServiceFeignClient.inspectAppTestPush(inspectMockAppData);
    }

}
